package com.xebialabs.deployit.task.archive

import com.xebialabs.deployit.engine.api.execution.{BlockState, TaskWithBlock}
import com.xebialabs.deployit.engine.tasker.Archive
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters
import org.joda.time.DateTime

import java.util

trait TaskArchiveStore extends Archive {

  override def archive(task: TaskWithBlock): Unit

  def updateSecureCi(
                      securedCi: Integer, environmentIds: Option[List[Integer]], applicationIds: Option[List[Integer]],
                      otherCiIds: Option[List[Integer]]): Unit

  def updateSecureCi(pk: Integer, securedCi: Integer): Unit

  def collectBatchUpdateSecureCi(pk: Integer, securedCi: Integer): List[BatchMessage] = {
    List(
      BatchEnvironmentMessage(securedCi, pk),
      BatchApplicationMessage(securedCi, pk),
      BatchControlTaskMessage(securedCi, pk)
    )
  }

  def batchUpdateSecureCi(batchMessages: Iterable[BatchMessage]): Unit

  def updateSecuredDirectoryReference(securedDirectoryRef: String,
                                      environmentIds: Option[List[Integer]],
                                      applicationIds: Option[List[Integer]],
                                      otherCiIds: Option[List[Integer]])

  def updateSecuredDirectoryReference(pk: Integer, securedDirectoryRef: String): Unit
}

trait TaskArchive extends DeploymentTaskAnalytics {

  def getTask(taskId: String): TaskReader

  def purgeTask(taskUuid: String): Unit

  def countTotalResults(params: ArchivedTaskSearchParameters): Int

  def searchForTasks(params: ArchivedTaskSearchParameters, streaming: Boolean): util.stream.Stream[TaskReader]

  def searchForMaps(params: ArchivedTaskSearchParameters, streaming: Boolean): util.stream.Stream[util.Map[String, Object]]

  def getAllArchivedEnvironments: util.List[String]

  def getAllArchivedEnvironmentsWithIds: util.Map[Integer, util.List[String]]

  def getAllArchivedApplicationsWithIds: util.Map[Integer, util.List[String]]

  def lastDeploymentsOnEnvironment(environment: String, before: DateTime, count: Int): util.stream.Stream[util.Map[String, Object]]

  def countSuccessfulDeploymentsOnEnvironments(envIds: util.List[String]): util.Map[String, Integer]

  def countSuccessfulDeploymentsOfApplications(appIds: util.List[String]): util.Map[String, Integer]

  def markTaskAsRolledBack(taskId: String): Unit

  def getReferences: util.List[String]
}

trait TaskReader {
  def fully: ArchivedTask

  def withoutSteps: ArchivedTask

  def withoutBlocks: ArchivedTask

  def block(blockId: String): BlockState

  def metadata: util.Map[String, String]
}
