package com.xebialabs.deployit.task.archive

import com.xebialabs.deployit.core.sql.batch.BatchCommandWithArgs

trait TaskArchiveRepository {
  def store(taskMessage: TaskMessage): Unit
  def updateSecureCi(securedCi: Integer, environmentIds: Option[List[Integer]],
                     applicationIds: Option[List[Integer]], otherCiIds: Option[List[Integer]]): Unit
  def updateSecureCi(ciId: Integer, securedCi: Integer): Unit

  def updateSecuredDirectoryRef(securedDirectoryRef: String, environmentIds: Option[List[Integer]],
                     applicationIds: Option[List[Integer]], otherCiIds: Option[List[Integer]]): Unit
  def updateSecuredDirectoryRef(ciId: Integer, securedDirectoryRef: String): Unit
}

trait BatchTaskArchiveRepository extends TaskArchiveRepository {

  def batchExecute(commands: Iterable[BatchCommandWithArgs]): Unit

  def batchUpdateSecureCi(messages: BatchSecureCiMessage): Unit
}
