package com.xebialabs.deployit

import com.xebialabs.deployit.core.events.ChangeSetEvent
import com.xebialabs.deployit.engine.tasker.websockets.RemoteChangeSetEventListener
import com.xebialabs.deployit.event.EventBusHolder
import nl.javadude.t2bus.Subscribe
import org.apache.pekko.actor.{ActorSelection, ActorSystem}

class ChangeSetEventPublisher(system: ActorSystem, masters: Seq[String]) {
  EventBusHolder.register(this)

  private val listeners: Seq[ActorSelection] = masters.map(_ + RemoteChangeSetEventListener.name).map(system.actorSelection)

  @Subscribe
  def handleChangeSetEvent(e: ChangeSetEvent): Unit = {
    listeners.foreach(_ ! e)
  }
}
