package com.xebialabs.deployit

import com.xebialabs.deployit.TaskEngineLaunchOptions.EmptyString

import java.io.File
import java.net.URL

import org.kohsuke.args4j.spi.StringArrayOptionHandler
import org.kohsuke.args4j.{Option => CmdLineOption}

object TaskEngineLaunchOptions {
  private val EmptyString = ""
  private var instance: TaskEngineLaunchOptions = _

  def setInstance(launchOptions: TaskEngineLaunchOptions): Unit = {
    instance = launchOptions
  }

  def getInstance: TaskEngineLaunchOptions = instance
}

class TaskEngineLaunchOptions {

  @CmdLineOption(name = "-hostname", usage = "The hostname of this worker (must be resolvable by the master) (defaults to hostname of localhost)", metaVar = "NAME")
  var hostname: String = _

  @CmdLineOption(name = "-port", usage = "The remoting port of this worker (default: 8180)")
  var port: Integer = _

  @CmdLineOption(name = "-master", usage = "The remoting endpoint of master (hostname:port) (e.g. master:8180)", required = true, metaVar = "NAME:PORT", handler = classOf[StringArrayOptionHandler])
  var masters: Array[String] = _

  @CmdLineOption(name = "-api", usage = "The HTTP endpoint of the master as a url (e.g. https://master:4516)", required = true)
  var api: URL = _

  @CmdLineOption(name = "-work", usage = "The work folder to use for this worker", metaVar = "FOLDER")
  var workDir: String = _

  @CmdLineOption(name = "-config", usage = "Additional HOCON config file for the worker")
  var configFile: File = _

  @CmdLineOption(name = "-name", usage = "The name of this worker to identify it in UI (defaults to hostname:port)", metaVar = "NAME")
  var name: String = _

  @CmdLineOption(name = "-socketTimeout", usage = "The timeout (in ms) for execution of API call (default: 120000)", metaVar = "SOCKET_TIMEOUT")
  var socketTimeout: Integer = 120000

  @CmdLineOption(name = "-skipPortInApi", usage = "Remove port from api url if this flag is present")
  var skipPortInApi: Boolean = _

  @CmdLineOption(name = "-keyStore", usage = "Path to the key store  (default: keystore)", metaVar = "KEY_STORE_PATH")
  var keyStore: String = _

  @CmdLineOption(name = "-keyPassword", usage = "Password for the key (default: changeme)", metaVar = "KEY_PASSWORD")
  var keyPassword: String = _

  @CmdLineOption(name = "-keyStorePassword", usage = "Password for the key store (default: changeme)", metaVar = "KEY_STORE_PASSWORD")
  var keyStorePassword: String = _

  @CmdLineOption(name = "-trustStore", usage = "Path to a trust store (default: truststore)", metaVar = "TRUST_STORE_PATH")
  var trustStore: String = _

  @CmdLineOption(name = "-trustStorePassword", usage = "Password for a trust store (default: changeme)", metaVar = "TRUST_STORE_PASSWORD")
  var trustStorePassword: String = _

  @CmdLineOption(name = "-pluginSource", usage = "Defines where the plugins will be loaded from. Allowed values: " +
    "'filesystem', 'database'. Defaults to 'database' if not specified")
  var pluginSource: String = _

  override def toString: String = {
    val masterList = Option(masters) match {
      case Some(m) => m.mkString(",")
      case None => EmptyString
    }
    "{ api: %s, master: [%s], name: %s, hostname: %s, port: %s, work: %s, socketTimeout: %d (default:120000), skipPortInApi: %b (default:false), keyStore: %s, keyPassword: %s, keyStorePassword: %s, trustStore: %s, trustStorePassword: %s }"
      .format(Option(api).getOrElse(EmptyString), masterList, Option(name).getOrElse(EmptyString), Option(hostname).getOrElse(EmptyString),
        Option(port).getOrElse(EmptyString), Option(workDir).getOrElse(EmptyString), socketTimeout, skipPortInApi,
        Option(keyStore).getOrElse(EmptyString), Option(keyPassword).getOrElse(EmptyString), Option(keyStorePassword).getOrElse(EmptyString),
        Option(trustStore).getOrElse(EmptyString), Option(trustStorePassword).getOrElse(EmptyString))
  }
}
