package com.xebialabs.deployit

import ai.digital.configuration.central.deploy.{CachesProperties, ServerSideProperties, TaskerSystemProperties}
import ai.digital.deploy.core.common.XldServerPaths
import ai.digital.deploy.core.common.ordering.ConfigurationItemIdComparator
import ai.digital.deploy.task.status.queue.PendoDeploymentStateProducer
import com.typesafe.config.Config
import com.xebialabs.deployit.booter.local.{GlobalContextManager, LocalBooter}
import com.xebialabs.deployit.booter.remote.Proxies
import com.xebialabs.deployit.core.config.{SqlConfiguration, TrueZipShutdownConfiguration, XldSpringConfig}
import com.xebialabs.deployit.core.rest.api.repository.DeployitRepositoryResource
import com.xebialabs.deployit.core.sql.{RepositoryHelper, SchemaInfo}
import com.xebialabs.deployit.engine.api._
import com.xebialabs.deployit.engine.tasker.repository.sql._
import com.xebialabs.deployit.event.EventBusHolder
import com.xebialabs.deployit.local.message.LocalisationConfiguration
import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.repository.ExternalPropertyLookupValueProvider
import com.xebialabs.deployit.repository.sql.SqlRepositoryMetadataService
import com.xebialabs.deployit.repository.sql.coc.DefaultSCMTraceability
import com.xebialabs.deployit.script.SpringBindings
import com.xebialabs.deployit.security.{RoleService => RoleRepository}
import com.xebialabs.deployit.service.externalproperties.ExternalValueProvider
import com.xebialabs.deployit.service.validation.Validator
import com.xebialabs.deployit.task.archive.queue.AsyncTaskArchiveProducer
import com.xebialabs.deployit.task.archive.sql.SqlTaskArchive
import com.xebialabs.deployit.upgrade.sql.SqlRepositoryVersionService
import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.plugin.classloader.PluginClassLoader
import com.xebialabs.plugin.manager.startup.PluginSynchronizer
import com.xebialabs.xldeploy.jms.adapter.DefaultQueueJmsBean
import com.xebialabs.xldeploy.status.queue.{DefaultDeploymentPackageStatusProducer, DeploymentPackageStatusStoreHolder}
import com.xebialabs.xlplatform.coc.service.SCMTraceabilityService
import com.xebialabs.xlplatform.config.ConfigurationHolder
import jakarta.annotation.PostConstruct
import org.springframework.beans.factory.annotation.{Autowired, Qualifier, Value}
import org.springframework.context.annotation._
import org.springframework.core.env.ConfigurableEnvironment
import org.springframework.jdbc.core.JdbcTemplate


@Configuration
@ComponentScan(value = Array(
  "ai.digital.deploy",
  "com.xebialabs.deployit.booter.local",
  "com.xebialabs.deployit.checksum",
  "com.xebialabs.deployit.config",
  "com.xebialabs.deployit.core.config",
  "com.xebialabs.deployit.core.defaults",
  "com.xebialabs.deployit.core.ordering",
  "com.xebialabs.deployit.core.server.service",
  "com.xebialabs.deployit.security.archive.sql",
  "com.xebialabs.deployit.security.service",
  "com.xebialabs.deployit.security.client",
  "com.xebialabs.deployit.repository",
   "com.xebialabs.deployit.upgrade.sql",
  "com.xebialabs.xlplatform.config",
),
  excludeFilters = Array(
    new ComponentScan.Filter(`type` = FilterType.REGEX,
      pattern = Array(
        "ai.digital.deploy.pendo.*",
        "ai.digital.deploy.scheduler.*",
        "ai.digital.deploy.task.status.queue.TaskPathStatusConsumer",
        "ai.digital.deploy.task.status.queue.TaskStepLogConsumer",
        "com.xebialabs.deployit.core.config.session.*",
        "com.xebialabs.deployit.core.config.DeployedPropertySetterConfig",
        "com.xebialabs.deployit.config.WebConfiguration"
      ))
  ))
@Import(
  Array(
    classOf[AsyncTaskArchiveProducer],
    classOf[CachesProperties],
    classOf[DefaultQueueJmsBean],
    classOf[DeployitRepositoryResource],
    classOf[LocalisationConfiguration],
    classOf[ServicesConfig],
    classOf[SpringBindings],
    classOf[SqlActiveTaskRepository],
    classOf[SqlConfiguration],
    classOf[SqlPendingTaskRepository],
    classOf[SqlRepositoryMetadataService],
    classOf[SqlRepositoryVersionService],
    classOf[SqlTaskArchive],
    classOf[SqlActiveTaskPathStatusRepository],
    classOf[SqlActiveTaskStepLogRepository],
    classOf[SqlWorkerRepository],
    classOf[ServerSideProperties],
    classOf[TaskerSystemProperties],
    classOf[Validator],
    classOf[XldSpringConfig],
    classOf[DefaultDeploymentPackageStatusProducer],
    classOf[DeploymentPackageStatusStoreHolder],
    classOf[PendoDeploymentStateProducer],
    classOf[TrueZipShutdownConfiguration]
  )
)
class TaskEngineConfig {

  @Autowired
  var environment: ConfigurableEnvironment = _

  @Value("${deploy.task.recovery-dir:work}")
  var recoveryDir: String = _

  @Bean def baseWorkDir: String = recoveryDir

  @Bean def proxies: Proxies = new ProxiesSupplier(TaskEngine.getInstance).get()

  @Bean def taskEngineProductConfiguration: TaskEngineProductConfiguration = new TaskEngineProductConfiguration()

  @Bean
  def passwordEncrypter: PasswordEncrypter = PasswordEncrypter.getInstance()

  @Bean
  def externalValueProvider(repositoryService: repository.RepositoryService): ExternalValueProvider =
    new ExternalPropertyLookupValueProvider(repositoryService)

  @Bean
  def configurationHolderInitializer(): Config = {
    ConfigurationHolder.get()
  }

  @Bean
  def defaultSCMTraceability(@Qualifier("mainJdbcTemplate") jdbcTemplate: JdbcTemplate,
                             @Qualifier("mainSchema") mainSchemaInfo: SchemaInfo): SCMTraceabilityService =
    new DefaultSCMTraceability(jdbcTemplate)(mainSchemaInfo)

  @Bean
  def serviceHolder(proxies: Proxies,
                    repositoryService: RepositoryService): ServiceHolder =
    new ServiceHolder(
      proxies.getControlService,
      proxies.getDeploymentService,
      proxies.getInspectionService,
      proxies.getMetadataService,
      proxies.getPackageService,
      proxies.getPermissionService,
      repositoryService,
      proxies.getRoleService,
      proxies.getServerService,
      proxies.getTaskService,
      proxies.getTaskBlockService,
      proxies.getUserService,
      null, // TODO Discuss whether this should be exposed
      proxies.getReportService
    )

  @Autowired
  var globalContextManager: GlobalContextManager = _

  @Autowired
  var pluginSynchronizer: PluginSynchronizer = _

  @PostConstruct
  def syncPluginsAndInitializeTypeSystem(): Unit = {
    syncPlugins()
    LocalBooter.reboot(XldServerPaths.TYPE_DEFAULTS, globalContextManager)
  }

  private def syncPlugins(): Unit = {
    Thread.currentThread.getContextClassLoader match {
      case pluginClassLoader: PluginClassLoader =>
        pluginClassLoader.clearClasspathRoots()
        pluginSynchronizer.syncPlugins()
        pluginClassLoader.refreshDirs()
      case _ =>
    }
  }
}

@ComponentScan(
  Array(
    "com.xebialabs.deployit.core.ordering",
    "com.xebialabs.deployit.core.rest.api.repository",
    "com.xebialabs.deployit.security",
    "com.xebialabs.deployit.service.externalproperties"
  )
)
@Import(
  Array(
    classOf[ConfigurationItemIdComparator],
    classOf[EventBusHolder],
  )
)
class ServicesConfig {

  import com.xebialabs.deployit.repository.RepositoryService

  @Bean
  def repositoryHelper(repositoryService: RepositoryService, roleRepository: RoleRepository): RepositoryHelper =
    new RepositoryHelper(
      repositoryService,
      roleRepository,
      java.util.Arrays.asList(Type.valueOf("overthere.RemoteHost"))
    )
}
