package com.xebialabs.deployit.resteasy

import java.io.ObjectInputStream

import jakarta.ws.rs.client.{ClientRequestContext, ClientResponseContext, ClientResponseFilter}
import jakarta.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE
import jakarta.ws.rs.core.Response.Status.Family.CLIENT_ERROR
import jakarta.ws.rs.ext.Provider

@Provider
class DeployitExceptionRethrower extends ClientResponseFilter
{
  override def filter(requestContext: ClientRequestContext, responseContext: ClientResponseContext): Unit = {
    responseContext.getStatusInfo.getFamily match {
      case CLIENT_ERROR if APPLICATION_OCTET_STREAM_TYPE.isCompatible(responseContext.getMediaType) =>
        throw new ObjectInputStream(responseContext.getEntityStream).readObject().asInstanceOf[Throwable]
      case _ =>
    }
  }
}
