/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.Arrays;
import swim.spatial.BitInterval;
import swim.spatial.QTreeContext;
import swim.spatial.QTreeEntry;
import swim.spatial.QTreeLeaf;
import swim.spatial.QTreeNodeCursor;
import swim.spatial.QTreePage;
import swim.util.Cursor;

final class QTreeNode<K, S, V>
extends QTreePage<K, S, V> {
    final QTreePage<K, S, V>[] pages;
    final QTreeEntry<K, S, V>[] slots;
    final long x;
    final long y;
    final long span;

    QTreeNode(QTreePage<K, S, V>[] pages, QTreeEntry<K, S, V>[] slots, long x, long y, long span) {
        this.pages = pages;
        this.slots = slots;
        this.x = x;
        this.y = y;
        this.span = span;
    }

    @Override
    public boolean isEmpty() {
        return this.span == 0L;
    }

    @Override
    public long span() {
        return this.span;
    }

    @Override
    public int arity() {
        return this.pages.length + this.slots.length;
    }

    @Override
    public QTreePage<K, S, V> getPage(int index) {
        return this.pages[index];
    }

    @Override
    public int slotCount() {
        return this.slots.length;
    }

    @Override
    public QTreeEntry<K, S, V> getSlot(int index) {
        return this.slots[index];
    }

    @Override
    public long x() {
        return this.x;
    }

    @Override
    public int xRank() {
        return Long.numberOfLeadingZeros(this.x ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long xBase() {
        return this.x << this.xRank();
    }

    @Override
    public long xMask() {
        return (1L << this.xRank()) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long xSplit() {
        return this.x << 1 & 1L;
    }

    @Override
    public long y() {
        return this.y;
    }

    @Override
    public int yRank() {
        return Long.numberOfLeadingZeros(this.y ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public long yBase() {
        return this.y << this.yRank();
    }

    @Override
    public long yMask() {
        return (1L << this.yRank()) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long ySplit() {
        return this.y << 1 & 1L;
    }

    @Override
    public boolean containsKey(K key, long xk, long yk, QTreeContext<K, S, V> tree) {
        int xRank = Long.numberOfLeadingZeros(this.x ^ 0xFFFFFFFFFFFFFFFFL);
        int yRank = Long.numberOfLeadingZeros(this.y ^ 0xFFFFFFFFFFFFFFFFL);
        int xkRank = Long.numberOfLeadingZeros(xk ^ 0xFFFFFFFFFFFFFFFFL);
        int ykRank = Long.numberOfLeadingZeros(yk ^ 0xFFFFFFFFFFFFFFFFL);
        if (xkRank <= xRank && ykRank <= yRank) {
            QTreePage<K, S, V> page;
            int i = this.scan(xk, yk);
            if (i >= 0 && xkRank <= (page = this.pages[i]).xRank() && ykRank <= page.yRank() && page.containsKey(key, xk, yk, tree)) {
                return true;
            }
            return this.lookup(key, tree) >= 0;
        }
        return false;
    }

    @Override
    public V get(K key, long xk, long yk, QTreeContext<K, S, V> tree) {
        int xRank = Long.numberOfLeadingZeros(this.x ^ 0xFFFFFFFFFFFFFFFFL);
        int yRank = Long.numberOfLeadingZeros(this.y ^ 0xFFFFFFFFFFFFFFFFL);
        int xkRank = Long.numberOfLeadingZeros(xk ^ 0xFFFFFFFFFFFFFFFFL);
        int ykRank = Long.numberOfLeadingZeros(yk ^ 0xFFFFFFFFFFFFFFFFL);
        if (xkRank <= xRank && ykRank <= yRank) {
            V value;
            QTreePage<K, S, V> page;
            int i = this.scan(xk, yk);
            if (i >= 0 && xkRank <= (page = this.pages[i]).xRank() && ykRank <= page.yRank() && (value = page.get(key, xk, yk, tree)) != null) {
                return value;
            }
            i = this.lookup(key, tree);
            if (i >= 0) {
                return this.slots[i].value;
            }
        }
        return null;
    }

    @Override
    QTreeNode<K, S, V> updated(K key, S shape, long xk, long yk, V newValue, QTreeContext<K, S, V> tree, boolean canSplit) {
        QTreePage<K, S, V>[] pages = this.pages;
        int n = pages.length;
        int j = this.lookup(xk, yk);
        int i = j >= 0 ? j : -(j + 1);
        QTreePage<K, S, V> oldPage = pages[i];
        QTreePage<K, S, V> newPage = oldPage.updated(key, shape, xk, yk, newValue, tree);
        if (oldPage.x() == newPage.x() && oldPage.y() == newPage.y()) {
            if (canSplit && oldPage.span() != newPage.span() && tree.pageShouldSplit(newPage)) {
                return this.updatedPageSplit(i, newPage, oldPage, tree);
            }
            return this.updatedPage(i, newPage, oldPage);
        }
        return this.coalescePage(this, i, newPage, oldPage, tree);
    }

    QTreeNode<K, S, V> coalescePage(QTreeNode<K, S, V> basePage, int i, QTreePage<K, S, V> newPage, QTreePage<K, S, V> oldPage, QTreeContext<K, S, V> tree) {
        while (true) {
            int j;
            if ((j = super.scan(newPage.x(), newPage.y())) < 0) {
                j = -(j + 1);
                return basePage.insertedPage(j, newPage).reinsertedSlots(tree);
            }
            i = j;
            oldPage = basePage.getPage(i);
            newPage = oldPage.mergedPage(newPage, tree);
        }
    }

    QTreeNode<K, S, V> updatedPage(int i, QTreePage<K, S, V> newPage, QTreePage<K, S, V> oldPage) {
        QTreePage<K, S, V>[] oldPages = this.pages;
        int n = oldPages.length;
        QTreePage[] newPages = new QTreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, n);
        newPages[i] = newPage;
        Arrays.sort(newPages, PAGE_ORDERING);
        long newSpan = this.span - oldPage.span() + newPage.span();
        return QTreeNode.create(newPages, this.slots, newSpan);
    }

    QTreeNode<K, S, V> updatedPageSplit(int i, QTreePage<K, S, V> newPage, QTreePage<K, S, V> oldPage, QTreeContext<K, S, V> tree) {
        QTreePage page = this.removedPage(i, oldPage);
        QTreeNode midPage = (QTreeNode)newPage.split(tree);
        QTreePage<K, S, V>[] midPages = midPage.pages;
        int midArity = midPages.length;
        if (midArity <= 1) {
            return this.updatedPage(i, newPage, oldPage);
        }
        for (int j = 0; j < midArity; ++j) {
            page = page.insertedPage((QTreePage)midPages[j], (QTreeContext)tree);
        }
        return page.mergedSlots((QTreeEntry[])midPage.slots, (QTreeContext)tree);
    }

    QTreeNode<K, S, V> updatedPageMerge(int i, QTreeNode<K, S, V> newPage, QTreePage<K, S, V> oldPage, QTreeContext<K, S, V> tree) {
        QTreePage page = this.removedPage(i, oldPage);
        QTreePage<K, S, V>[] newPages = newPage.pages;
        int pageCount = newPages.length;
        for (int j = 0; j < pageCount; ++j) {
            page = ((QTreeNode)page).insertedPage((QTreePage)newPages[j], (QTreeContext)tree);
        }
        QTreeEntry<K, S, V>[] newSlots = newPage.slots;
        int slotCount = newSlots.length;
        for (int j = 0; j < slotCount; ++j) {
            page = ((QTreeNode)page).updatedSlot((QTreeEntry)newSlots[j], (QTreeContext)tree);
        }
        return page;
    }

    @Override
    QTreeNode<K, S, V> mergedPage(QTreePage<K, S, V> newPage, QTreeContext<K, S, V> tree) {
        int i;
        QTreePage page = this;
        if (newPage instanceof QTreeNode) {
            int arity = newPage.arity();
            for (i = 0; i < arity; ++i) {
                page = page.insertedPage((QTreePage)newPage.getPage(i), (QTreeContext)tree);
            }
        }
        int slotCount = newPage.slotCount();
        for (i = 0; i < slotCount; ++i) {
            QTreeEntry<K, S, V> slot = newPage.getSlot(i);
            page = page.updated(slot.key, slot.shape, slot.x, slot.y, slot.value, (QTreeContext)tree, false);
        }
        return page;
    }

    @Override
    QTreeNode<K, S, V> mergedSlots(QTreeEntry<K, S, V>[] midSlots, QTreeContext<K, S, V> tree) {
        if (midSlots.length > 0) {
            QTreeEntry<K, S, V>[] oldSlots = this.slots;
            QTreeEntry[] newSlots = new QTreeEntry[oldSlots.length + midSlots.length];
            System.arraycopy(oldSlots, 0, newSlots, 0, oldSlots.length);
            System.arraycopy(midSlots, 0, newSlots, oldSlots.length, midSlots.length);
            Arrays.sort(newSlots, tree);
            long newSpan = this.span + (long)midSlots.length;
            return QTreeNode.create(this.pages, newSlots, newSpan);
        }
        return this;
    }

    QTreeNode<K, S, V> reinsertedSlots(QTreeContext<K, S, V> tree) {
        QTreePage page = this;
        QTreeEntry<K, S, V>[] oldSlots = this.slots;
        int oldSlotCount = oldSlots.length;
        QTreeEntry[] newSlots = null;
        int newSlotCount = 0;
        for (int i = 0; i < oldSlotCount; ++i) {
            QTreeEntry<K, S, V> slot = oldSlots[i];
            long x = slot.x;
            long y = slot.y;
            int j = page.lookup(x, y);
            if (j >= 0) {
                page = page.updated(slot.key, slot.shape, slot.x, slot.y, slot.value, (QTreeContext)tree, false);
                if (newSlots != null) continue;
                newSlots = new QTreeEntry[oldSlotCount - 1];
                System.arraycopy(oldSlots, 0, newSlots, 0, i);
                newSlotCount = i;
                continue;
            }
            if (newSlots == null) continue;
            newSlots[newSlotCount] = slot;
            ++newSlotCount;
        }
        if (newSlots != null) {
            if (newSlotCount == 0) {
                newSlots = EMPTY_SLOTS;
            } else if (newSlotCount < oldSlotCount - 1) {
                QTreeEntry[] resizedSlots = new QTreeEntry[newSlotCount];
                System.arraycopy(newSlots, 0, resizedSlots, 0, newSlotCount);
                newSlots = resizedSlots;
            }
            return QTreeNode.create(page.pages, newSlots, this.span);
        }
        return page;
    }

    @Override
    QTreeNode<K, S, V> insertedPage(QTreePage<K, S, V> newPage, QTreeContext<K, S, V> tree) {
        int i = this.lookup(newPage.x(), newPage.y());
        if (i < 0) {
            i = -(i + 1);
            return this.insertedPage(i, newPage);
        }
        return this.mergedPage((QTreePage)newPage, (QTreeContext)tree);
    }

    QTreeNode<K, S, V> insertedPage(int i, QTreePage<K, S, V> newPage) {
        QTreePage<K, S, V>[] oldPages = this.pages;
        int n = oldPages.length + 1;
        QTreePage[] newPages = new QTreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, i);
        newPages[i] = newPage;
        System.arraycopy(oldPages, i, newPages, i + 1, n - (i + 1));
        Arrays.sort(newPages, PAGE_ORDERING);
        long newSpan = this.span + newPage.span();
        return QTreeNode.create(newPages, this.slots, newSpan);
    }

    QTreeNode<K, S, V> insertedSlot(int i, K key, S shape, long xk, long yk, V newValue) {
        QTreeEntry<K, S, V>[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        QTreeEntry[] newSlots = new QTreeEntry[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        newSlots[i] = new QTreeEntry<K, S, V>(key, shape, xk, yk, newValue);
        System.arraycopy(oldSlots, i, newSlots, i + 1, n - (i + 1));
        return QTreeNode.create(this.pages, newSlots, this.span + 1L);
    }

    QTreeNode<K, S, V> updatedSlot(K key, S shape, long xk, long yk, V newValue, QTreeContext<K, S, V> tree) {
        return this.updatedSlot((QTreeEntry)new QTreeEntry<K, S, V>(key, shape, xk, yk, newValue), (QTreeContext)tree);
    }

    QTreeNode<K, S, V> updatedSlot(int i, K key, S shape, long xk, long yk, V newValue) {
        QTreeEntry<K, S, V>[] oldSlots = this.slots;
        QTreeEntry<K, S, V> oldSlot = oldSlots[i];
        long oldX = oldSlot.x;
        long oldY = oldSlot.y;
        if (!newValue.equals(oldSlot.value) || oldX != xk || oldY != yk) {
            int n = oldSlots.length;
            QTreeEntry[] newSlots = new QTreeEntry[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[i] = new QTreeEntry<K, S, V>(key, shape, xk, yk, newValue);
            return QTreeNode.create(this.pages, newSlots, this.span);
        }
        return this;
    }

    @Override
    QTreeNode<K, S, V> updatedSlot(QTreeEntry<K, S, V> newSlot, QTreeContext<K, S, V> tree) {
        int i = this.lookup(newSlot.key, tree);
        if (i >= 0) {
            return this.updatedSlot(i, newSlot);
        }
        i = -(i + 1);
        return this.insertedSlot(i, newSlot);
    }

    QTreeNode<K, S, V> updatedSlot(int i, QTreeEntry<K, S, V> newSlot) {
        QTreeEntry<K, S, V>[] oldSlots = this.slots;
        QTreeEntry<K, S, V> oldSlot = oldSlots[i];
        if (!newSlot.equals(oldSlot)) {
            int n = oldSlots.length;
            QTreeEntry[] newSlots = new QTreeEntry[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[i] = newSlot;
            return QTreeNode.create(this.pages, newSlots, this.span);
        }
        return this;
    }

    QTreeNode<K, S, V> insertedSlot(int i, QTreeEntry<K, S, V> newSlot) {
        QTreeEntry<K, S, V>[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        QTreeEntry[] newSlots = new QTreeEntry[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        newSlots[i] = newSlot;
        System.arraycopy(oldSlots, i, newSlots, i + 1, n - (i + 1));
        return QTreeNode.create(this.pages, newSlots, this.span);
    }

    @Override
    public QTreePage<K, S, V> removed(K key, long xk, long yk, QTreeContext<K, S, V> tree) {
        int xRank = Long.numberOfLeadingZeros(this.x ^ 0xFFFFFFFFFFFFFFFFL);
        int yRank = Long.numberOfLeadingZeros(this.y ^ 0xFFFFFFFFFFFFFFFFL);
        int xkRank = Long.numberOfLeadingZeros(xk ^ 0xFFFFFFFFFFFFFFFFL);
        int ykRank = Long.numberOfLeadingZeros(yk ^ 0xFFFFFFFFFFFFFFFFL);
        if (xkRank <= xRank && ykRank <= yRank) {
            QTreePage<K, S, V> newPage;
            QTreePage<K, S, V> oldPage;
            int i = this.scan(xk, yk);
            if (i >= 0 && (oldPage = this.pages[i]) != (newPage = oldPage.removed(key, xk, yk, tree))) {
                return this.replacedPage(i, newPage, oldPage, tree);
            }
            i = this.lookup(key, tree);
            if (i >= 0) {
                return this.removedSlot(i);
            }
        }
        return this;
    }

    QTreePage<K, S, V> replacedPage(int i, QTreePage<K, S, V> newPage, QTreePage<K, S, V> oldPage, QTreeContext<K, S, V> tree) {
        if (!newPage.isEmpty()) {
            if (newPage instanceof QTreeNode && tree.pageShouldMerge(newPage)) {
                return this.updatedPageMerge(i, (QTreeNode)newPage, oldPage, tree);
            }
            return this.updatedPage(i, newPage, oldPage);
        }
        if (this.pages.length > 2) {
            return this.removedPage(i, oldPage);
        }
        if (this.pages.length > 1) {
            QTreePage<K, S, V> onlyChild = i == 0 ? this.pages[1] : this.pages[0];
            if (this.slots.length == 0) {
                return onlyChild;
            }
            return onlyChild.mergedSlots(this.slots, tree);
        }
        if (this.slots.length > 0) {
            return QTreeLeaf.create(this.slots);
        }
        return QTreeLeaf.empty();
    }

    QTreeNode<K, S, V> removedPage(int i, QTreePage<K, S, V> oldPage) {
        QTreePage<K, S, V>[] oldPages = this.pages;
        int n = oldPages.length - 1;
        QTreePage[] newPages = new QTreePage[n];
        System.arraycopy(oldPages, 0, newPages, 0, i);
        System.arraycopy(oldPages, i + 1, newPages, i, n - i);
        Arrays.sort(newPages, PAGE_ORDERING);
        long newSpan = this.span - oldPage.span();
        return QTreeNode.create(newPages, this.slots, newSpan);
    }

    QTreeNode<K, S, V> removedSlot(int i) {
        QTreeEntry<K, S, V>[] oldSlots = this.slots;
        int n = oldSlots.length - 1;
        QTreeEntry[] newSlots = new QTreeEntry[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        System.arraycopy(oldSlots, i + 1, newSlots, i, n - i);
        return QTreeNode.create(this.pages, newSlots, this.span - 1L);
    }

    @Override
    public QTreePage<K, S, V> flattened(QTreeContext<K, S, V> tree) {
        QTreePage<K, S, V>[] pages = this.pages;
        QTreeEntry<K, S, V>[] slots = this.slots;
        if (pages.length > 1) {
            return this;
        }
        if (pages.length == 1) {
            QTreePage<K, S, V> onlyChild = pages[0];
            if (slots.length == 0) {
                return onlyChild;
            }
            return onlyChild.mergedSlots(slots, tree);
        }
        if (slots.length > 0) {
            return QTreeLeaf.create(slots);
        }
        return QTreeLeaf.empty();
    }

    @Override
    public QTreeNode<K, S, V> balanced(QTreeContext<K, S, V> tree) {
        if (this.pages.length > 1 && tree.pageShouldSplit(this)) {
            return this.split((QTreeContext)tree);
        }
        return this;
    }

    @Override
    public QTreeNode<K, S, V> split(QTreeContext<K, S, V> tree) {
        QTreeEntry[] newSlots;
        QTreePage[] newPages;
        long x = this.x;
        long y = this.y;
        int xRank = Long.numberOfLeadingZeros(x ^ 0xFFFFFFFFFFFFFFFFL);
        int yRank = Long.numberOfLeadingZeros(y ^ 0xFFFFFFFFFFFFFFFFL);
        int xnRank = Math.max(0, xRank - 1);
        int ynRank = Math.max(0, yRank - 1);
        long xnMask = (1L << xnRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long ynMask = (1L << ynRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long x0Base = x << xRank;
        long y0Base = y << yRank;
        long x1Base = x0Base | 1L << xnRank;
        long y1Base = y0Base | 1L << ynRank;
        int x00Rank = 0;
        int y00Rank = 0;
        int x01Rank = 0;
        int y01Rank = 0;
        int x10Rank = 0;
        int y10Rank = 0;
        int x11Rank = 0;
        int y11Rank = 0;
        int xX0Rank = 0;
        int yX0Rank = 0;
        int xX1Rank = 0;
        int yX1Rank = 0;
        long x00Base = 0L;
        long y00Base = 0L;
        long x01Base = 0L;
        long y01Base = 0L;
        long x10Base = 0L;
        long y10Base = 0L;
        long x11Base = 0L;
        long y11Base = 0L;
        long xX0Base = 0L;
        long yX0Base = 0L;
        long xX1Base = 0L;
        long yX1Base = 0L;
        long x00Mask = -1L;
        long y00Mask = -1L;
        long x01Mask = -1L;
        long y01Mask = -1L;
        long x10Mask = -1L;
        long y10Mask = -1L;
        long x11Mask = -1L;
        long y11Mask = -1L;
        long xX0Mask = -1L;
        long yX0Mask = -1L;
        long xX1Mask = -1L;
        long yX1Mask = -1L;
        QTreePage<K, S, V>[] pages = this.pages;
        QTreePage[] pages00 = null;
        QTreePage[] pages01 = null;
        QTreePage[] pages10 = null;
        QTreePage[] pages11 = null;
        int pageCount = pages.length;
        int pageCount00 = 0;
        int pageCount01 = 0;
        int pageCount10 = 0;
        int pageCount11 = 0;
        long span00 = 0L;
        long span01 = 0L;
        long span10 = 0L;
        long span11 = 0L;
        for (int i = 0; i < pageCount; ++i) {
            QTreePage<K, S, V> page = pages[i];
            long xc = page.x();
            long yc = page.y();
            int xcRank = Long.numberOfLeadingZeros(xc ^ 0xFFFFFFFFFFFFFFFFL);
            int ycRank = Long.numberOfLeadingZeros(yc ^ 0xFFFFFFFFFFFFFFFFL);
            long xcBase = xc << xcRank;
            long ycBase = yc << ycRank;
            long xcNorm = xcBase & xnMask;
            long ycNorm = ycBase & ynMask;
            if (xcNorm == x0Base) {
                if (ycNorm == y0Base) {
                    if (pages00 == null) {
                        pages00 = new QTreePage[pageCount];
                    }
                    pages00[pageCount00] = page;
                    ++pageCount00;
                    span00 += page.span();
                    x00Rank = Math.max(x00Rank, xcRank);
                    y00Rank = Math.max(y00Rank, ycRank);
                    x00Base |= xcBase;
                    y00Base |= ycBase;
                    x00Mask &= xcBase;
                    y00Mask &= ycBase;
                    continue;
                }
                if (pages01 == null) {
                    pages01 = new QTreePage[pageCount];
                }
                pages01[pageCount01] = page;
                ++pageCount01;
                span01 += page.span();
                x01Rank = Math.max(x01Rank, xcRank);
                y01Rank = Math.max(y01Rank, ycRank);
                x01Base |= xcBase;
                y01Base |= ycBase;
                x01Mask &= xcBase;
                y01Mask &= ycBase;
                continue;
            }
            if (ycNorm == y0Base) {
                if (pages10 == null) {
                    pages10 = new QTreePage[pageCount];
                }
                pages10[pageCount10] = page;
                ++pageCount10;
                span10 += page.span();
                x10Rank = Math.max(x10Rank, xcRank);
                y10Rank = Math.max(y10Rank, ycRank);
                x10Base |= xcBase;
                y10Base |= ycBase;
                x10Mask &= xcBase;
                y10Mask &= ycBase;
                continue;
            }
            if (pages11 == null) {
                pages11 = new QTreePage[pageCount];
            }
            pages11[pageCount11] = page;
            ++pageCount11;
            span11 += page.span();
            x11Rank = Math.max(x11Rank, xcRank);
            y11Rank = Math.max(y11Rank, ycRank);
            x11Base |= xcBase;
            y11Base |= ycBase;
            x11Mask &= xcBase;
            y11Mask &= ycBase;
        }
        QTreeEntry<K, S, V>[] slots = this.slots;
        QTreeEntry[] slots00 = null;
        QTreeEntry[] slots01 = null;
        QTreeEntry[] slots10 = null;
        QTreeEntry[] slots11 = null;
        QTreeEntry[] slotsX0 = null;
        QTreeEntry[] slotsX1 = null;
        QTreeEntry[] slotsXY = null;
        int slotCount = slots.length;
        int slotCount00 = 0;
        int slotCount01 = 0;
        int slotCount10 = 0;
        int slotCount11 = 0;
        int slotCountX0 = 0;
        int slotCountX1 = 0;
        int slotCountXY = 0;
        for (int i = 0; i < slotCount; ++i) {
            QTreeEntry<K, S, V> slot = slots[i];
            long xt = slot.x;
            long yt = slot.y;
            int xtRank = Long.numberOfLeadingZeros(xt ^ 0xFFFFFFFFFFFFFFFFL);
            int ytRank = Long.numberOfLeadingZeros(yt ^ 0xFFFFFFFFFFFFFFFFL);
            long xtBase = xt << xtRank;
            long ytBase = yt << ytRank;
            long xtNorm = xtBase & xnMask;
            long ytNorm = ytBase & ynMask;
            if (xnRank > 0 && xtRank > xnRank) {
                if (ynRank > 0 && ytRank > ynRank) {
                    slotsXY[slotCountXY] = slot;
                    ++slotCountXY;
                    continue;
                }
                if (ytNorm == y0Base) {
                    if (slotsX0 == null) {
                        slotsX0 = new QTreeEntry[slotCount];
                    }
                    slotsX0[slotCountX0] = slot;
                    ++slotCountX0;
                    xX0Rank = Math.max(xX0Rank, xtRank);
                    yX0Rank = Math.max(yX0Rank, ytRank);
                    xX0Base |= xtBase;
                    yX0Base |= ytBase;
                    xX0Mask &= xtBase;
                    yX0Mask &= ytBase;
                    continue;
                }
                if (slotsX1 == null) {
                    slotsX1 = new QTreeEntry[slotCount];
                }
                slotsX1[slotCountX1] = slot;
                ++slotCountX1;
                xX1Rank = Math.max(xX1Rank, xtRank);
                yX1Rank = Math.max(yX1Rank, ytRank);
                xX1Base |= xtBase;
                yX1Base |= ytBase;
                xX1Mask &= xtBase;
                yX1Mask &= ytBase;
                continue;
            }
            if (xtNorm == x0Base) {
                if (ytNorm == y0Base) {
                    if (slots00 == null) {
                        slots00 = new QTreeEntry[slotCount];
                    }
                    slots00[slotCount00] = slot;
                    ++slotCount00;
                    ++span00;
                    x00Rank = Math.max(x00Rank, xtRank);
                    y00Rank = Math.max(y00Rank, ytRank);
                    x00Base |= xtBase;
                    y00Base |= ytBase;
                    x00Mask &= xtBase;
                    y00Mask &= ytBase;
                    continue;
                }
                if (slots01 == null) {
                    slots01 = new QTreeEntry[slotCount];
                }
                slots01[slotCount01] = slot;
                ++slotCount01;
                ++span01;
                x01Rank = Math.max(x01Rank, xtRank);
                y01Rank = Math.max(y01Rank, ytRank);
                x01Base |= xtBase;
                y01Base |= ytBase;
                x01Mask &= xtBase;
                y01Mask &= ytBase;
                continue;
            }
            if (ytNorm == y0Base) {
                if (slots10 == null) {
                    slots10 = new QTreeEntry[slotCount];
                }
                slots10[slotCount10] = slot;
                ++slotCount10;
                ++span10;
                x10Rank = Math.max(x10Rank, xtRank);
                y10Rank = Math.max(y10Rank, ytRank);
                x10Base |= xtBase;
                y10Base |= ytBase;
                x10Mask &= xtBase;
                y10Mask &= ytBase;
                continue;
            }
            if (slots11 == null) {
                slots11 = new QTreeEntry[slotCount];
            }
            slots11[slotCount11] = slot;
            ++slotCount11;
            ++span11;
            x11Rank = Math.max(x11Rank, xtRank);
            y11Rank = Math.max(y11Rank, ytRank);
            x11Base |= xtBase;
            y11Base |= ytBase;
            x11Mask &= xtBase;
            y11Mask &= ytBase;
        }
        x00Mask ^= x00Base;
        y00Mask ^= y00Base;
        x01Mask ^= x01Base;
        y01Mask ^= y01Base;
        x10Mask ^= x10Base;
        y10Mask ^= y10Base;
        x11Mask ^= x11Base;
        y11Mask ^= y11Base;
        xX0Mask ^= xX0Base;
        yX0Mask ^= yX0Base;
        xX1Mask ^= xX1Base;
        yX1Mask ^= yX1Base;
        x00Rank = Math.max(x00Rank, 64 - Long.numberOfLeadingZeros(x00Mask));
        y00Rank = Math.max(y00Rank, 64 - Long.numberOfLeadingZeros(y00Mask));
        x01Rank = Math.max(x01Rank, 64 - Long.numberOfLeadingZeros(x01Mask));
        y01Rank = Math.max(y01Rank, 64 - Long.numberOfLeadingZeros(y01Mask));
        x10Rank = Math.max(x10Rank, 64 - Long.numberOfLeadingZeros(x10Mask));
        y10Rank = Math.max(y10Rank, 64 - Long.numberOfLeadingZeros(y10Mask));
        x11Rank = Math.max(x11Rank, 64 - Long.numberOfLeadingZeros(x11Mask));
        y11Rank = Math.max(y11Rank, 64 - Long.numberOfLeadingZeros(y11Mask));
        xX0Rank = Math.max(xX0Rank, 64 - Long.numberOfLeadingZeros(xX0Mask));
        yX0Rank = Math.max(yX0Rank, 64 - Long.numberOfLeadingZeros(yX0Mask));
        xX1Rank = Math.max(xX1Rank, 64 - Long.numberOfLeadingZeros(xX1Mask));
        yX1Rank = Math.max(yX1Rank, 64 - Long.numberOfLeadingZeros(yX1Mask));
        long x00 = BitInterval.from(x00Rank, x00Base);
        long y00 = BitInterval.from(y00Rank, y00Base);
        long x01 = BitInterval.from(x01Rank, x01Base);
        long y01 = BitInterval.from(y01Rank, y01Base);
        long x10 = BitInterval.from(x10Rank, x10Base);
        long y10 = BitInterval.from(y10Rank, y10Base);
        long x11 = BitInterval.from(x11Rank, x11Base);
        long y11 = BitInterval.from(y11Rank, y11Base);
        long xX0 = BitInterval.from(xX0Rank, xX0Base);
        long yX0 = BitInterval.from(yX0Rank, yX0Base);
        long xX1 = BitInterval.from(xX1Rank, xX1Base);
        long yX1 = BitInterval.from(yX1Rank, yX1Base);
        if (pageCount11 > 0 && pageCount01 > 0 && BitInterval.compare(x11, y11, x01, y01) == 0) {
            System.arraycopy(pages11, 0, pages01, pageCount01, pageCount11);
            pageCount01 += pageCount11;
            span01 += span11;
            if (slotCount11 > 0) {
                if (slots01 == null) {
                    slots01 = new QTreeEntry[slotCount];
                }
                System.arraycopy(slots11, 0, slots01, slotCount01, slotCount11);
                slotCount01 += slotCount11;
                slots11 = null;
                slotCount11 = 0;
            }
            x01 = BitInterval.union(x01, x11);
            y01 = BitInterval.union(y01, y11);
            pages11 = null;
            pageCount11 = 0;
            span11 = 0L;
        }
        if (pageCount01 > 0 && pageCount00 > 0 && BitInterval.compare(x01, y01, x00, y00) == 0) {
            System.arraycopy(pages01, 0, pages00, pageCount00, pageCount01);
            pageCount00 += pageCount01;
            span00 += span01;
            if (slotCount01 > 0) {
                if (slots00 == null) {
                    slots00 = new QTreeEntry[slotCount];
                }
                System.arraycopy(slots01, 0, slots00, slotCount00, slotCount01);
                slotCount00 += slotCount01;
                slots01 = null;
                slotCount01 = 0;
            }
            x00 = BitInterval.union(x00, x01);
            y00 = BitInterval.union(y00, y01);
            pages01 = null;
            pageCount01 = 0;
            span01 = 0L;
        }
        if (pageCount01 > 0 && pageCount10 > 0 && BitInterval.compare(x01, y01, x10, y10) == 0) {
            System.arraycopy(pages01, 0, pages10, pageCount10, pageCount01);
            pageCount10 += pageCount01;
            span10 += span01;
            if (slotCount01 > 0) {
                if (slots10 == null) {
                    slots10 = new QTreeEntry[slotCount];
                }
                System.arraycopy(slots01, 0, slots10, slotCount10, slotCount01);
                slotCount10 += slotCount01;
                slots01 = null;
                slotCount01 = 0;
            }
            x10 = BitInterval.union(x10, x01);
            y10 = BitInterval.union(y10, y01);
            pages01 = null;
            pageCount01 = 0;
            span01 = 0L;
        }
        if (pageCount10 > 0 && pageCount00 > 0 && BitInterval.compare(x10, y10, x00, y00) == 0) {
            System.arraycopy(pages10, 0, pages00, pageCount00, pageCount10);
            pageCount00 += pageCount10;
            span00 += span10;
            if (slotCount10 > 0) {
                if (slots00 == null) {
                    slots00 = new QTreeEntry[slotCount];
                }
                System.arraycopy(slots10, 0, slots00, slotCount00, slotCount10);
                slotCount00 += slotCount10;
                slots10 = null;
                slotCount10 = 0;
            }
            x00 = BitInterval.union(x00, x10);
            y00 = BitInterval.union(y00, y10);
            pages10 = null;
            pageCount10 = 0;
            span10 = 0L;
        }
        if (slotCountX1 > 0 && BitInterval.compare(xX1, yX1, x01, y01) == 0) {
            if (slots01 != null) {
                System.arraycopy(slotsX1, 0, slots01, slotCount01, slotCountX1);
            } else {
                slots01 = slotsX1;
            }
            slotCount01 += slotCountX1;
            span01 += (long)slotCountX1;
            x01 = BitInterval.union(x01, xX1);
            y01 = BitInterval.union(y01, yX1);
            slotsX1 = null;
            slotCountX1 = 0;
        }
        if (slotCountX0 > 0 && BitInterval.compare(xX0, yX0, x00, y00) == 0) {
            if (slots00 != null) {
                System.arraycopy(slotsX0, 0, slots00, slotCount00, slotCountX0);
            } else {
                slots00 = slotsX0;
            }
            slotCount00 += slotCountX0;
            span00 += (long)slotCountX0;
            x00 = BitInterval.union(x00, xX0);
            y00 = BitInterval.union(y00, yX0);
            slotsX0 = null;
            slotCountX0 = 0;
        }
        if (slotsX0 != null) {
            if (slotsXY == null) {
                slotsXY = new QTreeEntry[slotCount];
            }
            System.arraycopy(slotsX0, 0, slotsXY, slotCountXY, slotCountX0);
            slotCountXY += slotCountX0;
            slotsX0 = null;
            slotCountX0 = 0;
        }
        if (slotsX1 != null) {
            if (slotsXY == null) {
                slotsXY = new QTreeEntry[slotCount];
            }
            System.arraycopy(slotsX1, 0, slotsXY, slotCountXY, slotCountX1);
            slotCountXY += slotCountX1;
            slotsX1 = null;
            slotCountX1 = 0;
        }
        int pageCountXY = 0;
        if (pageCount00 > 0 || slotCount00 > 0) {
            ++pageCountXY;
        }
        if (pageCount01 > 0 || slotCount01 > 0) {
            ++pageCountXY;
        }
        if (pageCount10 > 0 || slotCount10 > 0) {
            ++pageCountXY;
        }
        if (pageCount11 > 0 || slotCount11 > 0) {
            ++pageCountXY;
        }
        QTreePage[] pagesXY = new QTreePage[pageCountXY];
        int pageOffsetXY = 0;
        if (pageCount00 > 0 || slotCount00 > 0) {
            if (pageCount00 < pageCount) {
                newPages = new QTreePage[pageCount00];
                System.arraycopy(pages00, 0, newPages, 0, pageCount00);
                pages00 = newPages;
            }
            if (slotCount00 == 0) {
                slots00 = EMPTY_SLOTS;
            } else if (slotCount00 < slotCount) {
                newSlots = new QTreeEntry[slotCount00];
                System.arraycopy(slots00, 0, newSlots, 0, slotCount00);
                slots00 = newSlots;
            }
            if (pageCount00 > 1 || pageCount00 == 1 && slotCount00 > 0) {
                Arrays.sort(pages00, PAGE_ORDERING);
                Arrays.sort(slots00, tree);
                pagesXY[pageOffsetXY] = new QTreeNode<K, S, V>(pages00, slots00, x00, y00, span00);
            } else if (slotCount00 == 0) {
                pagesXY[pageOffsetXY] = pages00[0];
            } else {
                Arrays.sort(slots00, tree);
                pagesXY[pageOffsetXY] = QTreeLeaf.create(slots00);
            }
            ++pageOffsetXY;
        }
        if (pageCount01 > 0 || slotCount01 > 0) {
            if (pageCount01 < pageCount) {
                newPages = new QTreePage[pageCount01];
                System.arraycopy(pages01, 0, newPages, 0, pageCount01);
                pages01 = newPages;
            }
            if (slotCount01 == 0) {
                slots01 = EMPTY_SLOTS;
            } else if (slotCount01 < slotCount) {
                newSlots = new QTreeEntry[slotCount01];
                System.arraycopy(slots01, 0, newSlots, 0, slotCount01);
                slots01 = newSlots;
            }
            if (pageCount01 > 1 || pageCount01 == 1 && slotCount01 > 0) {
                Arrays.sort(pages01, PAGE_ORDERING);
                Arrays.sort(slots01, tree);
                pagesXY[pageOffsetXY] = new QTreeNode<K, S, V>(pages01, slots01, x01, y01, span01);
            } else if (slotCount01 == 0) {
                pagesXY[pageOffsetXY] = pages01[0];
            } else {
                Arrays.sort(slots01, tree);
                pagesXY[pageOffsetXY] = QTreeLeaf.create(slots01);
            }
            ++pageOffsetXY;
        }
        if (pageCount10 > 0 || slotCount10 > 0) {
            if (pageCount10 < pageCount) {
                newPages = new QTreePage[pageCount10];
                System.arraycopy(pages10, 0, newPages, 0, pageCount10);
                pages10 = newPages;
            }
            if (slotCount10 == 0) {
                slots10 = EMPTY_SLOTS;
            } else if (slotCount10 < slotCount) {
                newSlots = new QTreeEntry[slotCount10];
                System.arraycopy(slots10, 0, newSlots, 0, slotCount10);
                slots10 = newSlots;
            }
            if (pageCount10 > 1 || pageCount10 == 1 && slotCount10 > 0) {
                Arrays.sort(pages10, PAGE_ORDERING);
                Arrays.sort(slots10, tree);
                pagesXY[pageOffsetXY] = new QTreeNode<K, S, V>(pages10, slots10, x10, y10, span10);
            } else if (slotCount10 == 0) {
                pagesXY[pageOffsetXY] = pages10[0];
            } else {
                Arrays.sort(slots10, tree);
                pagesXY[pageOffsetXY] = QTreeLeaf.create(slots10);
            }
            ++pageOffsetXY;
        }
        if (pageCount11 > 0 || slotCount11 > 0) {
            if (pageCount11 < pageCount) {
                newPages = new QTreePage[pageCount11];
                System.arraycopy(pages11, 0, newPages, 0, pageCount11);
                pages11 = newPages;
            }
            if (slotCount11 == 0) {
                slots11 = EMPTY_SLOTS;
            } else if (slotCount11 < slotCount) {
                newSlots = new QTreeEntry[slotCount11];
                System.arraycopy(slots11, 0, newSlots, 0, slotCount11);
                slots11 = newSlots;
            }
            if (pageCount11 > 1 || pageCount11 == 1 && slotCount11 > 0) {
                Arrays.sort(pages11, PAGE_ORDERING);
                Arrays.sort(slots11, tree);
                pagesXY[pageOffsetXY] = new QTreeNode<K, S, V>(pages11, slots11, x11, y11, span11);
            } else if (slotCount11 == 0) {
                pagesXY[pageOffsetXY] = pages11[0];
            } else {
                Arrays.sort(slots11, tree);
                pagesXY[pageOffsetXY] = QTreeLeaf.create(slots11);
            }
            ++pageOffsetXY;
        }
        Arrays.sort(pagesXY, PAGE_ORDERING);
        if (slotCountXY == 0) {
            slotsXY = EMPTY_SLOTS;
        } else if (slotCountXY < slotCount) {
            QTreeEntry[] newSlotsXY = new QTreeEntry[slotCountXY];
            System.arraycopy(slotsXY, 0, newSlotsXY, 0, slotCountXY);
            slotsXY = newSlotsXY;
        }
        Arrays.sort(slotsXY, tree);
        return QTreeNode.create(pagesXY, slotsXY, this.span);
    }

    @Override
    public Cursor<QTreeEntry<K, S, V>> cursor(long x, long y) {
        return new QTreeNodeCursor(this, x, y);
    }

    private int scan(long xk, long yk) {
        QTreePage<K, S, V>[] pages = this.pages;
        int j = 0;
        int n = pages.length;
        for (int i = 0; i < n; ++i) {
            QTreePage<K, S, V> page = pages[i];
            int order = BitInterval.compare(page.x(), page.y(), xk, yk);
            if (order == 0) {
                return i;
            }
            if (order >= 0) continue;
            j = i;
        }
        return -(j + 1);
    }

    private int lookup(long xk, long yk) {
        int yOrder;
        QTreePage<K, S, V>[] pages = this.pages;
        int l = 0;
        int u = pages.length - 1;
        while (l <= u) {
            int i = l + u >>> 1;
            int xOrder = BitInterval.compare(pages[i].x(), xk);
            if (xOrder < 0) {
                l = i + 1;
                continue;
            }
            if (xOrder > 0) {
                u = i - 1;
                continue;
            }
            l = i + 1;
        }
        --l;
        while (l >= 0 && (yOrder = BitInterval.compare(pages[l].y(), yk)) >= 0) {
            if (yOrder > 0) {
                --l;
                continue;
            }
            return l;
        }
        if (l >= 0) {
            return -(l + 1);
        }
        return -1;
    }

    private int lookup(K key, QTreeContext<K, S, V> tree) {
        QTreeEntry<K, S, V>[] slots = this.slots;
        int low = 0;
        int high = slots.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int order = tree.compareKey(key, slots[mid].key);
            if (order > 0) {
                low = mid + 1;
                continue;
            }
            if (order < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <K, S, V> QTreeNode<K, S, V> create(QTreePage<K, S, V>[] pages, QTreeEntry<K, S, V>[] slots, long span) {
        int i;
        int xRank = 0;
        int yRank = 0;
        long xBase = 0L;
        long yBase = 0L;
        long xMask = -1L;
        long yMask = -1L;
        int pageCount = pages.length;
        for (i = 0; i < pageCount; ++i) {
            QTreePage<K, S, V> page = pages[i];
            long cx = page.x();
            long cy = page.y();
            int cxRank = Long.numberOfLeadingZeros(cx ^ 0xFFFFFFFFFFFFFFFFL);
            int cyRank = Long.numberOfLeadingZeros(cy ^ 0xFFFFFFFFFFFFFFFFL);
            long cxBase = cx << cxRank;
            long cyBase = cy << cyRank;
            xRank = Math.max(xRank, cxRank);
            yRank = Math.max(yRank, cyRank);
            xBase |= cxBase;
            yBase |= cyBase;
            xMask &= cxBase;
            yMask &= cyBase;
        }
        int slotCount = slots.length;
        for (i = 0; i < slotCount; ++i) {
            QTreeEntry<K, S, V> slot = slots[i];
            long tx = slot.x;
            long ty = slot.y;
            int txRank = Long.numberOfLeadingZeros(tx ^ 0xFFFFFFFFFFFFFFFFL);
            int tyRank = Long.numberOfLeadingZeros(ty ^ 0xFFFFFFFFFFFFFFFFL);
            long txBase = tx << txRank;
            long tyBase = ty << tyRank;
            xRank = Math.max(xRank, txRank);
            yRank = Math.max(yRank, tyRank);
            xBase |= txBase;
            yBase |= tyBase;
            xMask &= txBase;
            yMask &= tyBase;
        }
        xRank = Math.max(xRank, 64 - Long.numberOfLeadingZeros(xMask ^= xBase));
        yRank = Math.max(yRank, 64 - Long.numberOfLeadingZeros(yMask ^= yBase));
        xMask = (1L << xRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        yMask = (1L << yRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long x = BitInterval.from(xRank, xBase &= xMask);
        long y = BitInterval.from(yRank, yBase &= yMask);
        return new QTreeNode<K, S, V>(pages, slots, x, y, span);
    }
}

