/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import swim.math.R2Shape;
import swim.math.R2ToZ2Operator;
import swim.math.Z2Form;
import swim.math.Z2ToR2Operator;
import swim.spatial.GeoProjection;
import swim.structure.Item;

final class WGS84
extends Z2Form<R2Shape>
implements R2ToZ2Operator {
    WGS84() {
    }

    public Class<?> type() {
        return R2Shape.class;
    }

    public long getXMin(R2Shape shape) {
        return WGS84.transformLng(shape.xMin());
    }

    public long getYMin(R2Shape shape) {
        return WGS84.transformLat(shape.yMin());
    }

    public long getXMax(R2Shape shape) {
        return WGS84.transformLng(shape.xMax());
    }

    public long getYMax(R2Shape shape) {
        return WGS84.transformLat(shape.yMax());
    }

    public boolean contains(R2Shape outer, R2Shape inner) {
        return outer.contains(inner);
    }

    public boolean intersects(R2Shape s, R2Shape t) {
        return s.intersects(t);
    }

    public Item mold(R2Shape shape) {
        return R2Shape.shapeForm().mold((Object)shape);
    }

    public R2Shape cast(Item item) {
        return (R2Shape)R2Shape.shapeForm().cast(item);
    }

    public long transformX(double lng, double lat) {
        return WGS84.transformLng(lng);
    }

    public long transformY(double lng, double lat) {
        return WGS84.transformLat(lat);
    }

    public Z2ToR2Operator inverse() {
        return GeoProjection.wgs84Inverse();
    }

    static long transformLng(double lng) {
        return (long)((Math.min(Math.max(-180.0, lng), 180.0) + 180.0) / 360.0 * 9.223372036854776E18);
    }

    static long transformLat(double lat) {
        return (long)((Math.min(Math.max(-90.0, lat), 90.0) + 90.0) / 180.0 * 9.223372036854776E18);
    }
}

