/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import java.util.ArrayDeque;

@Navigator.Name(value="navigation")
public class NavGraphNavigator
extends Navigator<NavGraph> {
    private static final String KEY_BACK_STACK_IDS = "androidx-nav-graph:navigator:backStackIds";
    private final NavigatorProvider mNavigatorProvider;
    private ArrayDeque<Integer> mBackStack = new ArrayDeque();

    public NavGraphNavigator(@NonNull NavigatorProvider navigatorProvider) {
        this.mNavigatorProvider = navigatorProvider;
    }

    @Override
    @NonNull
    public NavGraph createDestination() {
        return new NavGraph(this);
    }

    @Override
    @Nullable
    public NavDestination navigate(@NonNull NavGraph destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        int startId = destination.getStartDestination();
        if (startId == 0) {
            throw new IllegalStateException("no start destination defined via app:startDestination for " + destination.getDisplayName());
        }
        NavDestination startDestination = destination.findNode(startId, false);
        if (startDestination == null) {
            String dest = destination.getStartDestDisplayName();
            throw new IllegalArgumentException("navigation destination " + dest + " is not a direct child of this NavGraph");
        }
        if (navOptions == null || !navOptions.shouldLaunchSingleTop() || !this.isAlreadyTop(destination)) {
            this.mBackStack.add(destination.getId());
        }
        Object navigator = this.mNavigatorProvider.getNavigator(startDestination.getNavigatorName());
        return ((Navigator)navigator).navigate((NavDestination)startDestination, startDestination.addInDefaultArgs(args), navOptions, navigatorExtras);
    }

    private boolean isAlreadyTop(NavGraph destination) {
        if (this.mBackStack.isEmpty()) {
            return false;
        }
        int topDestId = this.mBackStack.peekLast();
        NavGraph current = destination;
        while (current.getId() != topDestId) {
            NavDestination startDestination = current.findNode(current.getStartDestination());
            if (startDestination instanceof NavGraph) {
                current = (NavGraph)startDestination;
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean popBackStack() {
        return this.mBackStack.pollLast() != null;
    }

    @Override
    @Nullable
    public Bundle onSaveState() {
        Bundle b = new Bundle();
        int[] backStack = new int[this.mBackStack.size()];
        int index = 0;
        for (Integer id : this.mBackStack) {
            backStack[index++] = id;
        }
        b.putIntArray(KEY_BACK_STACK_IDS, backStack);
        return b;
    }

    @Override
    public void onRestoreState(@Nullable Bundle savedState) {
        int[] backStack;
        if (savedState != null && (backStack = savedState.getIntArray(KEY_BACK_STACK_IDS)) != null) {
            this.mBackStack.clear();
            for (int destId : backStack) {
                this.mBackStack.add(destId);
            }
        }
    }
}

