/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity.compose.lint;

import androidx.activity.compose.lint.ActivityResultLaunchDetectorKt;
import androidx.compose.lint.ComposableUtilsKt;
import androidx.compose.lint.PsiUtilsKt;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Landroidx/activity/compose/lint/ActivityResultLaunchDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "activity-compose-lint"})
public final class ActivityResultLaunchDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue LaunchDuringComposition = Issue.Companion.create("LaunchDuringComposition", "Calls to `launch` should happen inside of a SideEffect and not during composition", "Calling `launch` during composition is incorrect. Doing so will cause launch to be called multiple times resulting in a RuntimeException. Instead, use `SideEffect` and `launch` inside of the suspending block. The block will only run after a successful composition.", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ActivityResultLaunchDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.TEST_SOURCES)));

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)ActivityResultLaunchDetectorKt.access$getLaunch$p().getShortName());
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!PsiUtilsKt.isInPackageName(method, ActivityResultLaunchDetectorKt.access$getPackageName$p())) {
            return;
        }
        if (ComposableUtilsKt.isInvokedWithinComposable((UExpression)node)) {
            JavaContext.report$default((JavaContext)context, (Issue)LaunchDuringComposition, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)"Calls to `launch` should happen inside of a SideEffect and not during composition", null, (int)16, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/activity/compose/lint/ActivityResultLaunchDetector$Companion;", "", "()V", "LaunchDuringComposition", "Lcom/android/tools/lint/detector/api/Issue;", "getLaunchDuringComposition", "()Lcom/android/tools/lint/detector/api/Issue;", "activity-compose-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getLaunchDuringComposition() {
            return LaunchDuringComposition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

