/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.camera.camera2.impl;

import android.hardware.camera2.CameraCaptureSession.CaptureCallback;

import androidx.annotation.NonNull;
import androidx.camera.core.CameraCaptureCallback;

/**
 * A {@link CameraCaptureCallback} which contains an {@link CaptureCallback} and doesn't handle the
 * callback.
 */
final class CaptureCallbackContainer extends CameraCaptureCallback {

    private final CaptureCallback mCaptureCallback;

    private CaptureCallbackContainer(CaptureCallback captureCallback) {
        if (captureCallback == null) {
            throw new NullPointerException("captureCallback is null");
        }
        mCaptureCallback = captureCallback;
    }

    static CaptureCallbackContainer create(CaptureCallback captureCallback) {
        return new CaptureCallbackContainer(captureCallback);
    }

    @NonNull
    CaptureCallback getCaptureCallback() {
        return mCaptureCallback;
    }
}
