/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.Camera2CameraFactory;
import androidx.camera.camera2.internal.Camera2DeviceSurfaceManager;
import androidx.camera.camera2.internal.ImageAnalysisConfigProvider;
import androidx.camera.camera2.internal.ImageCaptureConfigProvider;
import androidx.camera.camera2.internal.PreviewConfigProvider;
import androidx.camera.camera2.internal.VideoCaptureConfigProvider;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.InitializationException;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraFactory;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.ExtendableUseCaseConfigFactory;
import androidx.camera.core.impl.ImageAnalysisConfig;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.PreviewConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.VideoCaptureConfig;

public final class Camera2Config {
    private Camera2Config() {
    }

    @NonNull
    public static CameraXConfig defaultConfig() {
        CameraFactory.Provider cameraFactoryProvider = Camera2CameraFactory::new;
        CameraDeviceSurfaceManager.Provider surfaceManagerProvider = context -> {
            try {
                return new Camera2DeviceSurfaceManager(context);
            }
            catch (CameraUnavailableException e) {
                throw new InitializationException((Throwable)e);
            }
        };
        UseCaseConfigFactory.Provider configFactoryProvider = context -> {
            ExtendableUseCaseConfigFactory factory = new ExtendableUseCaseConfigFactory();
            factory.installDefaultProvider(ImageAnalysisConfig.class, (ConfigProvider)new ImageAnalysisConfigProvider(context));
            factory.installDefaultProvider(ImageCaptureConfig.class, (ConfigProvider)new ImageCaptureConfigProvider(context));
            factory.installDefaultProvider(VideoCaptureConfig.class, (ConfigProvider)new VideoCaptureConfigProvider(context));
            factory.installDefaultProvider(PreviewConfig.class, (ConfigProvider)new PreviewConfigProvider(context));
            return factory;
        };
        CameraXConfig.Builder appConfigBuilder = new CameraXConfig.Builder().setCameraFactoryProvider(cameraFactoryProvider).setDeviceSurfaceManagerProvider(surfaceManagerProvider).setUseCaseConfigFactoryProvider(configFactoryProvider);
        return appConfigBuilder.build();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final class DefaultProvider
    implements CameraXConfig.Provider {
        @NonNull
        public CameraXConfig getCameraXConfig() {
            return Camera2Config.defaultConfig();
        }
    }
}

