/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.impl;

import androidx.annotation.NonNull;
import androidx.camera.camera2.impl.CameraEventCallback;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.MultiValueSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CameraEventCallbacks
extends MultiValueSet<CameraEventCallback> {
    public CameraEventCallbacks(CameraEventCallback ... callbacks) {
        this.addAll(Arrays.asList(callbacks));
    }

    @NonNull
    public ComboCameraEventCallback createComboCallback() {
        return new ComboCameraEventCallback(this.getAllItems());
    }

    @NonNull
    public static CameraEventCallbacks createEmptyCallback() {
        return new CameraEventCallbacks(new CameraEventCallback[0]);
    }

    @NonNull
    public MultiValueSet<CameraEventCallback> clone() {
        CameraEventCallbacks ret = CameraEventCallbacks.createEmptyCallback();
        ret.addAll(this.getAllItems());
        return ret;
    }

    public static final class ComboCameraEventCallback {
        private final List<CameraEventCallback> mCallbacks = new ArrayList<CameraEventCallback>();

        ComboCameraEventCallback(List<CameraEventCallback> callbacks) {
            for (CameraEventCallback callback : callbacks) {
                this.mCallbacks.add(callback);
            }
        }

        @NonNull
        public List<CaptureConfig> onPresetSession() {
            ArrayList<CaptureConfig> ret = new ArrayList<CaptureConfig>();
            for (CameraEventCallback callback : this.mCallbacks) {
                CaptureConfig presetCaptureStage = callback.onPresetSession();
                if (presetCaptureStage == null) continue;
                ret.add(presetCaptureStage);
            }
            return ret;
        }

        @NonNull
        public List<CaptureConfig> onEnableSession() {
            ArrayList<CaptureConfig> ret = new ArrayList<CaptureConfig>();
            for (CameraEventCallback callback : this.mCallbacks) {
                CaptureConfig enableCaptureStage = callback.onEnableSession();
                if (enableCaptureStage == null) continue;
                ret.add(enableCaptureStage);
            }
            return ret;
        }

        @NonNull
        public List<CaptureConfig> onRepeating() {
            ArrayList<CaptureConfig> ret = new ArrayList<CaptureConfig>();
            for (CameraEventCallback callback : this.mCallbacks) {
                CaptureConfig repeatingCaptureStage = callback.onRepeating();
                if (repeatingCaptureStage == null) continue;
                ret.add(repeatingCaptureStage);
            }
            return ret;
        }

        @NonNull
        public List<CaptureConfig> onDisableSession() {
            ArrayList<CaptureConfig> ret = new ArrayList<CaptureConfig>();
            for (CameraEventCallback callback : this.mCallbacks) {
                CaptureConfig disableCaptureStage = callback.onDisableSession();
                if (disableCaptureStage == null) continue;
                ret.add(disableCaptureStage);
            }
            return ret;
        }

        @NonNull
        public List<CameraEventCallback> getCallbacks() {
            return this.mCallbacks;
        }
    }
}

