/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2CameraControl;
import androidx.camera.camera2.internal.TorchControl;
import androidx.camera.camera2.internal.ZoomControl;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import java.util.concurrent.Executor;

public final class Camera2CameraInfoImpl
implements CameraInfoInternal {
    private static final String TAG = "Camera2CameraInfo";
    private final String mCameraId;
    private final CameraCharacteristics mCameraCharacteristics;
    private final Camera2CameraControl mCamera2CameraControl;
    private final ZoomControl mZoomControl;
    private final TorchControl mTorchControl;

    Camera2CameraInfoImpl(@NonNull String cameraId, @NonNull CameraCharacteristics cameraCharacteristics, @NonNull Camera2CameraControl camera2CameraControl) {
        Preconditions.checkNotNull((Object)cameraCharacteristics, (Object)"Camera characteristics map is missing");
        this.mCameraId = (String)Preconditions.checkNotNull((Object)cameraId);
        this.mCameraCharacteristics = cameraCharacteristics;
        this.mCamera2CameraControl = camera2CameraControl;
        this.mZoomControl = camera2CameraControl.getZoomControl();
        this.mTorchControl = camera2CameraControl.getTorchControl();
        this.logDeviceInfo();
    }

    @NonNull
    public String getCameraId() {
        return this.mCameraId;
    }

    @Nullable
    public Integer getLensFacing() {
        Integer lensFacing = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
        Preconditions.checkNotNull((Object)lensFacing);
        switch (lensFacing) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return null;
    }

    public int getSensorRotationDegrees(int relativeRotation) {
        Integer sensorOrientation = this.getSensorOrientation();
        int relativeRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees((int)relativeRotation);
        Integer lensFacing = this.getLensFacing();
        boolean isOppositeFacingScreen = lensFacing != null && 1 == lensFacing;
        return CameraOrientationUtil.getRelativeImageRotation((int)relativeRotationDegrees, (int)sensorOrientation, (boolean)isOppositeFacingScreen);
    }

    int getSensorOrientation() {
        Integer sensorOrientation = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Preconditions.checkNotNull((Object)sensorOrientation);
        return sensorOrientation;
    }

    int getSupportedHardwareLevel() {
        Integer deviceLevel = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        Preconditions.checkNotNull((Object)deviceLevel);
        return deviceLevel;
    }

    public int getSensorRotationDegrees() {
        return this.getSensorRotationDegrees(0);
    }

    private void logDeviceInfo() {
        this.logDeviceLevel();
    }

    private void logDeviceLevel() {
        String levelString;
        int deviceLevel = this.getSupportedHardwareLevel();
        switch (deviceLevel) {
            case 2: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LEGACY";
                break;
            }
            case 4: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_EXTERNAL";
                break;
            }
            case 0: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED";
                break;
            }
            case 1: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_FULL";
                break;
            }
            case 3: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_3";
                break;
            }
            default: {
                levelString = "Unknown value: " + deviceLevel;
            }
        }
        Log.i((String)TAG, (String)("Device Level: " + levelString));
    }

    public boolean hasFlashUnit() {
        Boolean hasFlashUnit = (Boolean)this.mCameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        Preconditions.checkNotNull((Object)hasFlashUnit);
        return hasFlashUnit;
    }

    @NonNull
    public LiveData<Integer> getTorchState() {
        return this.mTorchControl.getTorchState();
    }

    @NonNull
    public LiveData<ZoomState> getZoomState() {
        return this.mZoomControl.getZoomState();
    }

    @NonNull
    public String getImplementationType() {
        int hardwareLevel = this.getSupportedHardwareLevel();
        return hardwareLevel == 2 ? "androidx.camera.camera2.legacy" : "androidx.camera.camera2";
    }

    public void addSessionCaptureCallback(@NonNull Executor executor, @NonNull CameraCaptureCallback callback) {
        this.mCamera2CameraControl.addSessionCameraCaptureCallback(executor, callback);
    }

    public void removeSessionCaptureCallback(@NonNull CameraCaptureCallback callback) {
        this.mCamera2CameraControl.removeSessionCameraCaptureCallback(callback);
    }
}

