/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CaptureOptionUnpacker;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeviceProperties;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.UseCaseConfig;

final class ImageCaptureOptionUnpacker
extends Camera2CaptureOptionUnpacker {
    static final ImageCaptureOptionUnpacker INSTANCE = new ImageCaptureOptionUnpacker();
    private DeviceProperties mDeviceProperties = DeviceProperties.create();

    ImageCaptureOptionUnpacker() {
    }

    @Override
    public void unpack(@NonNull UseCaseConfig<?> config, @NonNull CaptureConfig.Builder builder) {
        super.unpack(config, builder);
        if (!(config instanceof ImageCaptureConfig)) {
            throw new IllegalArgumentException("config is not ImageCaptureConfig");
        }
        ImageCaptureConfig imageCaptureConfig = (ImageCaptureConfig)config;
        Camera2ImplConfig.Builder camera2ConfigBuilder = new Camera2ImplConfig.Builder();
        if (imageCaptureConfig.hasCaptureMode()) {
            this.applyPixelHdrPlusChangeForCaptureMode(imageCaptureConfig.getCaptureMode(), camera2ConfigBuilder);
        }
        builder.addImplementationOptions((Config)camera2ConfigBuilder.build());
    }

    void setDeviceProperty(DeviceProperties deviceProperties) {
        this.mDeviceProperties = deviceProperties;
    }

    @SuppressLint(value={"NewApi"})
    private void applyPixelHdrPlusChangeForCaptureMode(int captureMode, Camera2ImplConfig.Builder builder) {
        if ("Google".equals(this.mDeviceProperties.manufacturer()) && ("Pixel 2".equals(this.mDeviceProperties.model()) || "Pixel 3".equals(this.mDeviceProperties.model())) && this.mDeviceProperties.sdkVersion() >= 26) {
            switch (captureMode) {
                case 0: {
                    builder.setCaptureRequestOption(CaptureRequest.CONTROL_ENABLE_ZSL, true);
                    break;
                }
                case 1: {
                    builder.setCaptureRequestOption(CaptureRequest.CONTROL_ENABLE_ZSL, false);
                }
            }
        }
    }
}

