/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.SurfaceTexture;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2SessionOptionUnpacker;
import androidx.camera.camera2.internal.MeteringRepeatingConfig;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;

public class MeteringRepeating
extends UseCase {
    private static final String TAG = "MeteringRepeating";
    private DeferrableSurface mDeferrableSurface;
    private static final boolean DEBUG = Log.isLoggable((String)"MeteringRepeating", (int)3);

    public MeteringRepeating(@NonNull MeteringRepeatingConfig config) {
        super((UseCaseConfig)config);
    }

    public MeteringRepeating(@NonNull CameraInternal cameraInternal) {
        this(new MeteringRepeatingConfig.Builder().getUseCaseConfig());
        this.onAttach(cameraInternal);
        this.updateSuggestedResolution(new Size(640, 480));
    }

    @NonNull
    protected UseCaseConfig.Builder<?, ?, ?> getDefaultBuilder(@Nullable CameraInfo cameraInfo) {
        return new MeteringRepeatingConfig.Builder().setSessionOptionUnpacker(new Camera2SessionOptionUnpacker());
    }

    public void clear() {
        this.notifyInactive();
        if (DEBUG) {
            Log.d((String)TAG, (String)"MeteringRepeating clear!");
        }
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = null;
        super.clear();
    }

    @NonNull
    protected Size onSuggestedResolutionUpdated(@NonNull Size suggestedResolution) {
        MeteringRepeatingConfig configWithDefaults = (MeteringRepeatingConfig)this.getUseCaseConfig();
        SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        surfaceTexture.setDefaultBufferSize(0, 0);
        Surface surface = new Surface(surfaceTexture);
        SessionConfig.Builder builder = SessionConfig.Builder.createFrom((UseCaseConfig)configWithDefaults);
        builder.setTemplateType(1);
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = new ImmediateSurface(surface);
        this.mDeferrableSurface.getTerminationFuture().addListener(() -> {
            if (DEBUG) {
                Log.d((String)TAG, (String)"Release metering surface and surface texture");
            }
            surface.release();
            surfaceTexture.release();
        }, CameraXExecutors.directExecutor());
        builder.addSurface(this.mDeferrableSurface);
        this.updateSessionConfig(builder.build());
        this.notifyActive();
        return new Size(0, 0);
    }
}

