/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CameraAccessExceptionCompat
extends Exception {
    public static final int CAMERA_IN_USE = 4;
    public static final int MAX_CAMERAS_IN_USE = 5;
    public static final int CAMERA_DISABLED = 1;
    public static final int CAMERA_DISCONNECTED = 2;
    public static final int CAMERA_ERROR = 3;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final int CAMERA_DEPRECATED_HAL = 1000;
    @VisibleForTesting
    static final Set<Integer> PLATFORM_ERRORS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(4, 5, 1, 2, 3)));
    public static final int CAMERA_UNAVAILABLE_DO_NOT_DISTURB = 10001;
    @VisibleForTesting
    static final Set<Integer> COMPAT_ERRORS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(10001)));
    private final int mReason;
    private final CameraAccessException mCameraAccessException;

    public CameraAccessExceptionCompat(int reason) {
        super(CameraAccessExceptionCompat.getDefaultMessage(reason));
        this.mReason = reason;
        this.mCameraAccessException = PLATFORM_ERRORS.contains(reason) ? new CameraAccessException(reason) : null;
    }

    public CameraAccessExceptionCompat(int reason, @Nullable String message) {
        super(CameraAccessExceptionCompat.getCombinedMessage(reason, message));
        this.mReason = reason;
        this.mCameraAccessException = PLATFORM_ERRORS.contains(reason) ? new CameraAccessException(reason, message) : null;
    }

    public CameraAccessExceptionCompat(int reason, @Nullable String message, @Nullable Throwable cause) {
        super(CameraAccessExceptionCompat.getCombinedMessage(reason, message), cause);
        this.mReason = reason;
        this.mCameraAccessException = PLATFORM_ERRORS.contains(reason) ? new CameraAccessException(reason, message, cause) : null;
    }

    public CameraAccessExceptionCompat(int reason, @Nullable Throwable cause) {
        super(CameraAccessExceptionCompat.getDefaultMessage(reason), cause);
        this.mReason = reason;
        this.mCameraAccessException = PLATFORM_ERRORS.contains(reason) ? new CameraAccessException(reason, null, cause) : null;
    }

    private CameraAccessExceptionCompat(@NonNull CameraAccessException e) {
        super(e.getMessage(), e.getCause());
        this.mReason = e.getReason();
        this.mCameraAccessException = e;
    }

    public final int getReason() {
        return this.mReason;
    }

    @Nullable
    public CameraAccessException toCameraAccessException() {
        return this.mCameraAccessException;
    }

    @NonNull
    public static CameraAccessExceptionCompat toCameraAccessExceptionCompat(@NonNull CameraAccessException cameraAccessException) {
        if (cameraAccessException == null) {
            throw new NullPointerException("cameraAccessException should not be null");
        }
        return new CameraAccessExceptionCompat(cameraAccessException);
    }

    @Nullable
    private static String getDefaultMessage(int problem) {
        switch (problem) {
            case 4: {
                return "The camera device is in use already";
            }
            case 5: {
                return "The system-wide limit for number of open cameras has been reached, and more camera devices cannot be opened until previous instances are closed.";
            }
            case 2: {
                return "The camera device is removable and has been disconnected from the Android device, or the camera service has shut down the connection due to a higher-priority access request for the camera device.";
            }
            case 1: {
                return "The camera is disabled due to a device policy, and cannot be opened.";
            }
            case 3: {
                return "The camera device is currently in the error state; no further calls to it will succeed.";
            }
            case 10001: {
                return "Some API 28 devices cannot access the camera when the device is in \"Do Not Disturb\" mode. The camera will not be accessible until \"Do Not Disturb\" mode is disabled.";
            }
        }
        return null;
    }

    private static String getCombinedMessage(int problem, String message) {
        String problemString = CameraAccessExceptionCompat.getProblemString(problem);
        return String.format("%s (%d): %s", problemString, problem, message);
    }

    @NonNull
    private static String getProblemString(int problem) {
        String problemString;
        switch (problem) {
            case 4: {
                problemString = "CAMERA_IN_USE";
                break;
            }
            case 5: {
                problemString = "MAX_CAMERAS_IN_USE";
                break;
            }
            case 2: {
                problemString = "CAMERA_DISCONNECTED";
                break;
            }
            case 1: {
                problemString = "CAMERA_DISABLED";
                break;
            }
            case 3: {
                problemString = "CAMERA_ERROR";
                break;
            }
            case 1000: {
                problemString = "CAMERA_DEPRECATED_HAL";
                break;
            }
            case 10001: {
                problemString = "CAMERA_UNAVAILABLE_DO_NOT_DISTURB";
                break;
            }
            default: {
                problemString = "<UNKNOWN ERROR>";
            }
        }
        return problemString;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface AccessError {
    }
}

