/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.params;

import android.hardware.camera2.params.OutputConfiguration;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompatApi24Impl;
import androidx.core.util.Preconditions;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;

@RequiresApi(value=26)
class OutputConfigurationCompatApi26Impl
extends OutputConfigurationCompatApi24Impl {
    private static final String MAX_SHARED_SURFACES_COUNT_FIELD = "MAX_SURFACES_COUNT";
    private static final String SURFACES_FIELD = "mSurfaces";

    OutputConfigurationCompatApi26Impl(@NonNull Surface surface) {
        this(new OutputConfigurationParamsApi26(new OutputConfiguration(surface)));
    }

    OutputConfigurationCompatApi26Impl(@NonNull Object outputConfiguration) {
        super(outputConfiguration);
    }

    @RequiresApi(value=26)
    static OutputConfigurationCompatApi26Impl wrap(@NonNull OutputConfiguration outputConfiguration) {
        return new OutputConfigurationCompatApi26Impl(new OutputConfigurationParamsApi26(outputConfiguration));
    }

    private static int getMaxSharedSurfaceCountApi26() throws NoSuchFieldException, IllegalAccessException {
        Field maxSurfacesCountField = OutputConfiguration.class.getDeclaredField(MAX_SHARED_SURFACES_COUNT_FIELD);
        maxSurfacesCountField.setAccessible(true);
        return maxSurfacesCountField.getInt(null);
    }

    private static List<Surface> getMutableSurfaceListApi26(OutputConfiguration outputConfiguration) throws NoSuchFieldException, IllegalAccessException {
        Field surfacesField = OutputConfiguration.class.getDeclaredField(SURFACES_FIELD);
        surfacesField.setAccessible(true);
        return (List)surfacesField.get(outputConfiguration);
    }

    @Override
    public void enableSurfaceSharing() {
        ((OutputConfiguration)this.getOutputConfiguration()).enableSurfaceSharing();
    }

    @Override
    final boolean isSurfaceSharingEnabled() {
        throw new AssertionError((Object)"isSurfaceSharingEnabled() should not be called on API >= 26");
    }

    @Override
    public void addSurface(@NonNull Surface surface) {
        ((OutputConfiguration)this.getOutputConfiguration()).addSurface(surface);
    }

    @Override
    public void setPhysicalCameraId(@Nullable String physicalCameraId) {
        ((OutputConfigurationParamsApi26)this.mObject).mPhysicalCameraId = physicalCameraId;
    }

    @Override
    @Nullable
    public String getPhysicalCameraId() {
        return ((OutputConfigurationParamsApi26)this.mObject).mPhysicalCameraId;
    }

    @Override
    public void removeSurface(@NonNull Surface surface) {
        if (this.getSurface() == surface) {
            throw new IllegalArgumentException("Cannot remove surface associated with this output configuration");
        }
        try {
            List<Surface> surfaces = OutputConfigurationCompatApi26Impl.getMutableSurfaceListApi26((OutputConfiguration)this.getOutputConfiguration());
            if (!surfaces.remove(surface)) {
                throw new IllegalArgumentException("Surface is not part of this output configuration");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Log.e((String)"OutputConfigCompat", (String)"Unable to remove surface from this output configuration.", (Throwable)e);
        }
    }

    @Override
    public int getMaxSharedSurfaceCount() {
        try {
            return OutputConfigurationCompatApi26Impl.getMaxSharedSurfaceCountApi26();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Log.e((String)"OutputConfigCompat", (String)"Unable to retrieve max shared surface count.", (Throwable)e);
            return super.getMaxSharedSurfaceCount();
        }
    }

    @Override
    @NonNull
    public List<Surface> getSurfaces() {
        return ((OutputConfiguration)this.getOutputConfiguration()).getSurfaces();
    }

    @Override
    public Object getOutputConfiguration() {
        Preconditions.checkArgument((boolean)(this.mObject instanceof OutputConfigurationParamsApi26));
        return ((OutputConfigurationParamsApi26)this.mObject).mOutputConfiguration;
    }

    private static final class OutputConfigurationParamsApi26 {
        final OutputConfiguration mOutputConfiguration;
        @Nullable
        String mPhysicalCameraId;

        OutputConfigurationParamsApi26(@NonNull OutputConfiguration configuration) {
            this.mOutputConfiguration = configuration;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OutputConfigurationParamsApi26)) {
                return false;
            }
            OutputConfigurationParamsApi26 otherOutputConfig = (OutputConfigurationParamsApi26)obj;
            return Objects.equals(this.mOutputConfiguration, otherOutputConfig.mOutputConfiguration) && Objects.equals(this.mPhysicalCameraId, otherOutputConfig.mPhysicalCameraId);
        }

        public int hashCode() {
            int h = 1;
            h = (h << 5) - h ^ this.mOutputConfiguration.hashCode();
            h = (h << 5) - h ^ (this.mPhysicalCameraId == null ? 0 : this.mPhysicalCameraId.hashCode());
            return h;
        }
    }
}

