/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.internal.Camera2SessionOptionUnpacker;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.Logger;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.ImmediateSurface;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.Executor;

class MeteringRepeatingSession {
    private static final String TAG = "MeteringRepeating";
    private DeferrableSurface mDeferrableSurface;
    @NonNull
    private final SessionConfig mSessionConfig;

    MeteringRepeatingSession(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat) {
        MeteringRepeatingConfig configWithDefaults = new MeteringRepeatingConfig();
        final SurfaceTexture surfaceTexture = new SurfaceTexture(0);
        Size meteringSurfaceSize = this.getMinimumPreviewSize(cameraCharacteristicsCompat);
        Logger.d((String)TAG, (String)("MerteringSession SurfaceTexture size: " + meteringSurfaceSize));
        surfaceTexture.setDefaultBufferSize(meteringSurfaceSize.getWidth(), meteringSurfaceSize.getHeight());
        final Surface surface = new Surface(surfaceTexture);
        SessionConfig.Builder builder = SessionConfig.Builder.createFrom((UseCaseConfig)configWithDefaults);
        builder.setTemplateType(1);
        this.mDeferrableSurface = new ImmediateSurface(surface);
        Futures.addCallback((ListenableFuture)this.mDeferrableSurface.getTerminationFuture(), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                surface.release();
                surfaceTexture.release();
            }

            public void onFailure(Throwable t) {
                throw new IllegalStateException("Future should never fail. Did it get completed by GC?", t);
            }
        }, (Executor)CameraXExecutors.directExecutor());
        builder.addSurface(this.mDeferrableSurface);
        this.mSessionConfig = builder.build();
    }

    @NonNull
    SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @NonNull
    String getName() {
        return TAG;
    }

    void clear() {
        Logger.d((String)TAG, (String)"MeteringRepeating clear!");
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
        }
        this.mDeferrableSurface = null;
    }

    @NonNull
    private Size getMinimumPreviewSize(@NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat) {
        StreamConfigurationMap map = (StreamConfigurationMap)cameraCharacteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (map == null) {
            Logger.e((String)TAG, (String)"Can not retrieve SCALER_STREAM_CONFIGURATION_MAP.");
            return new Size(0, 0);
        }
        Size[] outputSizes = Build.VERSION.SDK_INT < 23 ? map.getOutputSizes(SurfaceTexture.class) : map.getOutputSizes(34);
        if (outputSizes == null) {
            Logger.e((String)TAG, (String)"Can not get output size list.");
            return new Size(0, 0);
        }
        return Collections.min(Arrays.asList(outputSizes), (o1, o2) -> {
            int result = Long.signum((long)o1.getWidth() * (long)o1.getHeight() - (long)o2.getWidth() * (long)o2.getHeight());
            return result;
        });
    }

    private static class MeteringRepeatingConfig
    implements UseCaseConfig<UseCase> {
        @NonNull
        private final Config mConfig;

        MeteringRepeatingConfig() {
            MutableOptionsBundle mutableOptionsBundle = MutableOptionsBundle.create();
            mutableOptionsBundle.insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, (Object)new Camera2SessionOptionUnpacker());
            this.mConfig = mutableOptionsBundle;
        }

        @NonNull
        public Config getConfig() {
            return this.mConfig;
        }
    }
}

