/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExcludedSupportedSizesQuirk
implements Quirk {
    private static final String TAG = "ExcludedSupportedSizesQuirk";

    static boolean load() {
        return ExcludedSupportedSizesQuirk.isOnePlus6() || ExcludedSupportedSizesQuirk.isOnePlus6T();
    }

    private static boolean isOnePlus6() {
        return "OnePlus".equalsIgnoreCase(Build.BRAND) && "OnePlus6".equalsIgnoreCase(Build.DEVICE);
    }

    private static boolean isOnePlus6T() {
        return "OnePlus".equalsIgnoreCase(Build.BRAND) && "OnePlus6T".equalsIgnoreCase(Build.DEVICE);
    }

    @NonNull
    public List<Size> getExcludedSizes(@NonNull String cameraId, int imageFormat) {
        if (ExcludedSupportedSizesQuirk.isOnePlus6()) {
            return this.getOnePlus6ExcludedSizes(cameraId, imageFormat);
        }
        if (ExcludedSupportedSizesQuirk.isOnePlus6T()) {
            return this.getOnePlus6TExcludedSizes(cameraId, imageFormat);
        }
        Logger.w((String)TAG, (String)"Cannot retrieve list of supported sizes to exclude on this device.");
        return Collections.emptyList();
    }

    @NonNull
    private List<Size> getOnePlus6ExcludedSizes(@NonNull String cameraId, int imageFormat) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (cameraId.equals("0") && imageFormat == 256) {
            sizes.add(new Size(4160, 3120));
            sizes.add(new Size(4000, 3000));
        }
        return sizes;
    }

    @NonNull
    private List<Size> getOnePlus6TExcludedSizes(@NonNull String cameraId, int imageFormat) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        if (cameraId.equals("0") && imageFormat == 256) {
            sizes.add(new Size(4160, 3120));
            sizes.add(new Size(4000, 3000));
        }
        return sizes;
    }
}

