/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.internal.compat.quirk.SoftwareJpegEncodingPreferredQuirk;
import androidx.core.util.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class JpegHalCorruptImageQuirk
implements SoftwareJpegEncodingPreferredQuirk {
    private static final Set<String> KNOWN_AFFECTED_DEVICES = new HashSet<String>(Arrays.asList("heroqltevzw", "heroqltetmo"));
    private static final Set<Integer> SUPPORTED_HARDWARE_LEVELS = new HashSet<Integer>();

    static boolean load(@NonNull CameraCharacteristicsCompat characteristicsCompat) {
        int hardwareLevel = (Integer)Preconditions.checkNotNull((Object)((Integer)characteristicsCompat.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL)));
        return KNOWN_AFFECTED_DEVICES.contains(Build.DEVICE.toLowerCase(Locale.US)) && SUPPORTED_HARDWARE_LEVELS.contains(hardwareLevel);
    }

    static {
        SUPPORTED_HARDWARE_LEVELS.add(1);
        if (Build.VERSION.SDK_INT >= 24) {
            SUPPORTED_HARDWARE_LEVELS.add(3);
        }
    }
}

