/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCharacteristics;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.camera.camera2.internal.Camera2CamcorderProfileProvider;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.ExposureControl;
import androidx.camera.camera2.internal.ZoomControl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.quirk.CameraQuirks;
import androidx.camera.camera2.interop.Camera2CameraInfo;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraState;
import androidx.camera.core.ExperimentalExposureCompensation;
import androidx.camera.core.ExposureState;
import androidx.camera.core.Logger;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.CamcorderProfileProvider;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
public final class Camera2CameraInfoImpl
implements CameraInfoInternal {
    private static final String TAG = "Camera2CameraInfo";
    private final String mCameraId;
    private final CameraCharacteristicsCompat mCameraCharacteristicsCompat;
    private final Camera2CameraInfo mCamera2CameraInfo;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @Nullable
    private Camera2CameraControlImpl mCamera2CameraControlImpl;
    @GuardedBy(value="mLock")
    @Nullable
    private RedirectableLiveData<Integer> mRedirectTorchStateLiveData = null;
    @GuardedBy(value="mLock")
    @Nullable
    private RedirectableLiveData<ZoomState> mRedirectZoomStateLiveData = null;
    @NonNull
    private final RedirectableLiveData<CameraState> mCameraStateLiveData;
    @GuardedBy(value="mLock")
    @Nullable
    private List<Pair<CameraCaptureCallback, Executor>> mCameraCaptureCallbacks = null;
    @NonNull
    private final Quirks mCameraQuirks;
    @NonNull
    private final CamcorderProfileProvider mCamera2CamcorderProfileProvider;

    Camera2CameraInfoImpl(@NonNull String cameraId, @NonNull CameraCharacteristicsCompat cameraCharacteristicsCompat) {
        this.mCameraId = (String)Preconditions.checkNotNull((Object)cameraId);
        this.mCameraCharacteristicsCompat = cameraCharacteristicsCompat;
        this.mCamera2CameraInfo = new Camera2CameraInfo(this);
        this.mCameraQuirks = CameraQuirks.get(cameraId, cameraCharacteristicsCompat);
        this.mCamera2CamcorderProfileProvider = new Camera2CamcorderProfileProvider(cameraId, cameraCharacteristicsCompat);
        this.mCameraStateLiveData = new RedirectableLiveData<CameraState>(CameraState.create((CameraState.Type)CameraState.Type.CLOSED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void linkWithCameraControl(@NonNull Camera2CameraControlImpl camera2CameraControlImpl) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCamera2CameraControlImpl = camera2CameraControlImpl;
            if (this.mRedirectZoomStateLiveData != null) {
                this.mRedirectZoomStateLiveData.redirectTo(this.mCamera2CameraControlImpl.getZoomControl().getZoomState());
            }
            if (this.mRedirectTorchStateLiveData != null) {
                this.mRedirectTorchStateLiveData.redirectTo(this.mCamera2CameraControlImpl.getTorchControl().getTorchState());
            }
            if (this.mCameraCaptureCallbacks != null) {
                for (Pair<CameraCaptureCallback, Executor> pair : this.mCameraCaptureCallbacks) {
                    this.mCamera2CameraControlImpl.addSessionCameraCaptureCallback((Executor)pair.second, (CameraCaptureCallback)pair.first);
                }
                this.mCameraCaptureCallbacks = null;
            }
        }
        this.logDeviceInfo();
    }

    void setCameraStateSource(@NonNull LiveData<CameraState> cameraStateSource) {
        this.mCameraStateLiveData.redirectTo(cameraStateSource);
    }

    @NonNull
    public String getCameraId() {
        return this.mCameraId;
    }

    @NonNull
    public CameraCharacteristicsCompat getCameraCharacteristicsCompat() {
        return this.mCameraCharacteristicsCompat;
    }

    @Nullable
    public Integer getLensFacing() {
        Integer lensFacing = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.LENS_FACING);
        Preconditions.checkNotNull((Object)lensFacing);
        switch (lensFacing) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return null;
    }

    public int getSensorRotationDegrees(int relativeRotation) {
        Integer sensorOrientation = this.getSensorOrientation();
        int relativeRotationDegrees = CameraOrientationUtil.surfaceRotationToDegrees((int)relativeRotation);
        Integer lensFacing = this.getLensFacing();
        boolean isOppositeFacingScreen = lensFacing != null && 1 == lensFacing;
        return CameraOrientationUtil.getRelativeImageRotation((int)relativeRotationDegrees, (int)sensorOrientation, (boolean)isOppositeFacingScreen);
    }

    int getSensorOrientation() {
        Integer sensorOrientation = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Preconditions.checkNotNull((Object)sensorOrientation);
        return sensorOrientation;
    }

    int getSupportedHardwareLevel() {
        Integer deviceLevel = (Integer)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        Preconditions.checkNotNull((Object)deviceLevel);
        return deviceLevel;
    }

    public int getSensorRotationDegrees() {
        return this.getSensorRotationDegrees(0);
    }

    private void logDeviceInfo() {
        this.logDeviceLevel();
    }

    private void logDeviceLevel() {
        String levelString;
        int deviceLevel = this.getSupportedHardwareLevel();
        switch (deviceLevel) {
            case 2: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LEGACY";
                break;
            }
            case 4: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_EXTERNAL";
                break;
            }
            case 0: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED";
                break;
            }
            case 1: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_FULL";
                break;
            }
            case 3: {
                levelString = "INFO_SUPPORTED_HARDWARE_LEVEL_3";
                break;
            }
            default: {
                levelString = "Unknown value: " + deviceLevel;
            }
        }
        Logger.i((String)TAG, (String)("Device Level: " + levelString));
    }

    public boolean hasFlashUnit() {
        Boolean hasFlashUnit = (Boolean)this.mCameraCharacteristicsCompat.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        Preconditions.checkNotNull((Object)hasFlashUnit);
        return hasFlashUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LiveData<Integer> getTorchState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                if (this.mRedirectTorchStateLiveData == null) {
                    this.mRedirectTorchStateLiveData = new RedirectableLiveData<Integer>(0);
                }
                return this.mRedirectTorchStateLiveData;
            }
            if (this.mRedirectTorchStateLiveData != null) {
                return this.mRedirectTorchStateLiveData;
            }
            return this.mCamera2CameraControlImpl.getTorchControl().getTorchState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public LiveData<ZoomState> getZoomState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                if (this.mRedirectZoomStateLiveData == null) {
                    this.mRedirectZoomStateLiveData = new RedirectableLiveData<ZoomState>(ZoomControl.getDefaultZoomState(this.mCameraCharacteristicsCompat));
                }
                return this.mRedirectZoomStateLiveData;
            }
            if (this.mRedirectZoomStateLiveData != null) {
                return this.mRedirectZoomStateLiveData;
            }
            return this.mCamera2CameraControlImpl.getZoomControl().getZoomState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @ExperimentalExposureCompensation
    public ExposureState getExposureState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                return ExposureControl.getDefaultExposureState(this.mCameraCharacteristicsCompat);
            }
            return this.mCamera2CameraControlImpl.getExposureControl().getExposureState();
        }
    }

    @NonNull
    public LiveData<CameraState> getCameraState() {
        return this.mCameraStateLiveData;
    }

    @NonNull
    public String getImplementationType() {
        int hardwareLevel = this.getSupportedHardwareLevel();
        return hardwareLevel == 2 ? "androidx.camera.camera2.legacy" : "androidx.camera.camera2";
    }

    @NonNull
    public CamcorderProfileProvider getCamcorderProfileProvider() {
        return this.mCamera2CamcorderProfileProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionCaptureCallback(@NonNull Executor executor, @NonNull CameraCaptureCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                if (this.mCameraCaptureCallbacks == null) {
                    this.mCameraCaptureCallbacks = new ArrayList<Pair<CameraCaptureCallback, Executor>>();
                }
                this.mCameraCaptureCallbacks.add((Pair<CameraCaptureCallback, Executor>)new Pair((Object)callback, (Object)executor));
                return;
            }
            this.mCamera2CameraControlImpl.addSessionCameraCaptureCallback(executor, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionCaptureCallback(@NonNull CameraCaptureCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCamera2CameraControlImpl == null) {
                if (this.mCameraCaptureCallbacks == null) {
                    return;
                }
                Iterator<Pair<CameraCaptureCallback, Executor>> it = this.mCameraCaptureCallbacks.iterator();
                while (it.hasNext()) {
                    Pair<CameraCaptureCallback, Executor> pair = it.next();
                    if (pair.first != callback) continue;
                    it.remove();
                }
                return;
            }
            this.mCamera2CameraControlImpl.removeSessionCameraCaptureCallback(callback);
        }
    }

    @NonNull
    public Quirks getCameraQuirks() {
        return this.mCameraQuirks;
    }

    @NonNull
    public Camera2CameraInfo getCamera2CameraInfo() {
        return this.mCamera2CameraInfo;
    }

    static class RedirectableLiveData<T>
    extends MediatorLiveData<T> {
        private LiveData<T> mLiveDataSource;
        private T mInitialValue;

        RedirectableLiveData(T initialValue) {
            this.mInitialValue = initialValue;
        }

        void redirectTo(@NonNull LiveData<T> liveDataSource) {
            if (this.mLiveDataSource != null) {
                super.removeSource(this.mLiveDataSource);
            }
            this.mLiveDataSource = liveDataSource;
            super.addSource(liveDataSource, arg_0 -> ((RedirectableLiveData)this).setValue(arg_0));
        }

        public <S> void addSource(@NonNull LiveData<S> source, @NonNull Observer<? super S> onChanged) {
            throw new UnsupportedOperationException();
        }

        public T getValue() {
            return (T)(this.mLiveDataSource == null ? this.mInitialValue : this.mLiveDataSource.getValue());
        }
    }
}

