/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.os.Build;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.core.CameraControl;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class FocusMeteringControl {
    private static final String TAG = "FocusMeteringControl";
    private final Camera2CameraControlImpl mCameraControl;
    final Executor mExecutor;
    private final ScheduledExecutorService mScheduler;
    private volatile boolean mIsActive = false;
    private boolean mIsInAfAutoMode = false;
    @NonNull
    Integer mCurrentAfState = 0;
    private ScheduledFuture<?> mAutoCancelHandle;
    long mFocusTimeoutCounter = 0L;
    boolean mIsAutoFocusCompleted = false;
    boolean mIsFocusSuccessful = false;
    private Camera2CameraControlImpl.CaptureResultListener mSessionListenerForFocus = null;
    private Camera2CameraControlImpl.CaptureResultListener mSessionListenerForCancel = null;
    private MeteringRectangle[] mAfRects = new MeteringRectangle[0];
    private MeteringRectangle[] mAeRects = new MeteringRectangle[0];
    private MeteringRectangle[] mAwbRects = new MeteringRectangle[0];
    MeteringRectangle[] mDefaultAfRects = new MeteringRectangle[0];
    MeteringRectangle[] mDefaultAeRects = new MeteringRectangle[0];
    MeteringRectangle[] mDefaultAwbRects = new MeteringRectangle[0];
    CallbackToFutureAdapter.Completer<FocusMeteringResult> mRunningActionCompleter = null;
    CallbackToFutureAdapter.Completer<Void> mRunningCancelCompleter = null;

    FocusMeteringControl(@NonNull Camera2CameraControlImpl cameraControl, @NonNull ScheduledExecutorService scheduler, @NonNull Executor executor) {
        this.mCameraControl = cameraControl;
        this.mExecutor = executor;
        this.mScheduler = scheduler;
    }

    void setDefaultRequestBuilder(@NonNull CaptureRequest.Builder builder) {
        this.mDefaultAfRects = (MeteringRectangle[])builder.get(CaptureRequest.CONTROL_AF_REGIONS);
        this.mDefaultAeRects = (MeteringRectangle[])builder.get(CaptureRequest.CONTROL_AE_REGIONS);
        this.mDefaultAwbRects = (MeteringRectangle[])builder.get(CaptureRequest.CONTROL_AWB_REGIONS);
    }

    void setActive(boolean isActive) {
        if (isActive == this.mIsActive) {
            return;
        }
        this.mIsActive = isActive;
        if (!this.mIsActive) {
            this.cancelFocusAndMeteringWithoutAsyncResult();
        }
    }

    void addFocusMeteringOptions(@NonNull Camera2ImplConfig.Builder configBuilder) {
        int afMode = this.mIsInAfAutoMode ? 1 : 4;
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_MODE, this.mCameraControl.getSupportedAfMode(afMode));
        if (this.mAfRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_REGIONS, this.mAfRects);
        }
        if (this.mAeRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_REGIONS, this.mAeRects);
        }
        if (this.mAwbRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AWB_REGIONS, this.mAwbRects);
        }
    }

    private static boolean isValid(@NonNull MeteringPoint pt) {
        return pt.getX() >= 0.0f && pt.getX() <= 1.0f && pt.getY() >= 0.0f && pt.getY() <= 1.0f;
    }

    private static PointF getFovAdjustedPoint(@NonNull MeteringPoint meteringPoint, @NonNull Rational cropRegionAspectRatio, @NonNull Rational defaultAspectRatio) {
        Rational fovAspectRatio = defaultAspectRatio;
        if (meteringPoint.getSurfaceAspectRatio() != null) {
            fovAspectRatio = meteringPoint.getSurfaceAspectRatio();
        }
        PointF adjustedPoint = new PointF(meteringPoint.getX(), meteringPoint.getY());
        if (!fovAspectRatio.equals((Object)cropRegionAspectRatio)) {
            if (fovAspectRatio.compareTo(cropRegionAspectRatio) > 0) {
                float heightOfCropRegion = (float)(fovAspectRatio.doubleValue() / cropRegionAspectRatio.doubleValue());
                float top_padding = (float)(((double)heightOfCropRegion - 1.0) / 2.0);
                adjustedPoint.y = (top_padding + adjustedPoint.y) * (1.0f / heightOfCropRegion);
            } else {
                float widthOfCropRegion = (float)(cropRegionAspectRatio.doubleValue() / fovAspectRatio.doubleValue());
                float left_padding = (float)(((double)widthOfCropRegion - 1.0) / 2.0);
                adjustedPoint.x = (left_padding + adjustedPoint.x) * (1.0f / widthOfCropRegion);
            }
        }
        return adjustedPoint;
    }

    private static MeteringRectangle getMeteringRect(MeteringPoint meteringPoint, PointF adjustedPoint, Rect cropRegion) {
        int centerX = (int)((float)cropRegion.left + adjustedPoint.x * (float)cropRegion.width());
        int centerY = (int)((float)cropRegion.top + adjustedPoint.y * (float)cropRegion.height());
        int width = (int)(meteringPoint.getSize() * (float)cropRegion.width());
        int height = (int)(meteringPoint.getSize() * (float)cropRegion.height());
        Rect focusRect = new Rect(centerX - width / 2, centerY - height / 2, centerX + width / 2, centerY + height / 2);
        focusRect.left = FocusMeteringControl.rangeLimit(focusRect.left, cropRegion.right, cropRegion.left);
        focusRect.right = FocusMeteringControl.rangeLimit(focusRect.right, cropRegion.right, cropRegion.left);
        focusRect.top = FocusMeteringControl.rangeLimit(focusRect.top, cropRegion.bottom, cropRegion.top);
        focusRect.bottom = FocusMeteringControl.rangeLimit(focusRect.bottom, cropRegion.bottom, cropRegion.top);
        return new MeteringRectangle(focusRect, 1000);
    }

    private static int rangeLimit(int val, int max, int min) {
        return Math.min(Math.max(val, min), max);
    }

    ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction action, @Nullable Rational defaultAspectRatio) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.startFocusAndMeteringInternal((CallbackToFutureAdapter.Completer<FocusMeteringResult>)completer, action, defaultAspectRatio));
            return "startFocusAndMetering";
        });
    }

    void startFocusAndMeteringInternal(@NonNull CallbackToFutureAdapter.Completer<FocusMeteringResult> completer, @NonNull FocusMeteringAction action, @Nullable Rational defaultAspectRatio) {
        PointF adjustedPoint;
        MeteringRectangle meteringRectangle;
        int supportedAwbCount;
        int supportedAeCount;
        if (!this.mIsActive) {
            completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            return;
        }
        if (action.getMeteringPointsAf().isEmpty() && action.getMeteringPointsAe().isEmpty() && action.getMeteringPointsAwb().isEmpty()) {
            completer.setException((Throwable)new IllegalArgumentException("No AF/AE/AWB MeteringPoints are added."));
            return;
        }
        int supportedAfCount = Math.min(action.getMeteringPointsAf().size(), this.mCameraControl.getMaxAfRegionCount());
        int totalSupportedCount = supportedAfCount + (supportedAeCount = Math.min(action.getMeteringPointsAe().size(), this.mCameraControl.getMaxAeRegionCount())) + (supportedAwbCount = Math.min(action.getMeteringPointsAwb().size(), this.mCameraControl.getMaxAwbRegionCount()));
        if (totalSupportedCount <= 0) {
            completer.setException((Throwable)new IllegalArgumentException("None of the specified AF/AE/AWB MeteringPoints is supported on this camera."));
            return;
        }
        ArrayList meteringPointListAF = new ArrayList();
        ArrayList meteringPointListAE = new ArrayList();
        ArrayList meteringPointListAWB = new ArrayList();
        if (supportedAfCount > 0) {
            meteringPointListAF.addAll(action.getMeteringPointsAf().subList(0, supportedAfCount));
        }
        if (supportedAeCount > 0) {
            meteringPointListAE.addAll(action.getMeteringPointsAe().subList(0, supportedAeCount));
        }
        if (supportedAwbCount > 0) {
            meteringPointListAWB.addAll(action.getMeteringPointsAwb().subList(0, supportedAwbCount));
        }
        Rect cropSensorRegion = this.mCameraControl.getCropSensorRegion();
        Rational cropRegionAspectRatio = new Rational(cropSensorRegion.width(), cropSensorRegion.height());
        if (defaultAspectRatio == null) {
            defaultAspectRatio = cropRegionAspectRatio;
        }
        ArrayList<MeteringRectangle> meteringRectanglesListAF = new ArrayList<MeteringRectangle>();
        ArrayList<MeteringRectangle> meteringRectanglesListAE = new ArrayList<MeteringRectangle>();
        ArrayList<MeteringRectangle> meteringRectanglesListAWB = new ArrayList<MeteringRectangle>();
        for (MeteringPoint meteringPoint : meteringPointListAF) {
            if (!FocusMeteringControl.isValid(meteringPoint) || (meteringRectangle = FocusMeteringControl.getMeteringRect(meteringPoint, adjustedPoint = FocusMeteringControl.getFovAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio), cropSensorRegion)).getWidth() == 0 || meteringRectangle.getHeight() == 0) continue;
            meteringRectanglesListAF.add(meteringRectangle);
        }
        for (MeteringPoint meteringPoint : meteringPointListAE) {
            if (!FocusMeteringControl.isValid(meteringPoint) || (meteringRectangle = FocusMeteringControl.getMeteringRect(meteringPoint, adjustedPoint = FocusMeteringControl.getFovAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio), cropSensorRegion)).getWidth() == 0 || meteringRectangle.getHeight() == 0) continue;
            meteringRectanglesListAE.add(meteringRectangle);
        }
        for (MeteringPoint meteringPoint : meteringPointListAWB) {
            if (!FocusMeteringControl.isValid(meteringPoint) || (meteringRectangle = FocusMeteringControl.getMeteringRect(meteringPoint, adjustedPoint = FocusMeteringControl.getFovAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio), cropSensorRegion)).getWidth() == 0 || meteringRectangle.getHeight() == 0) continue;
            meteringRectanglesListAWB.add(meteringRectangle);
        }
        if (meteringRectanglesListAF.isEmpty() && meteringRectanglesListAE.isEmpty() && meteringRectanglesListAWB.isEmpty()) {
            completer.setException((Throwable)new IllegalArgumentException("None of the specified AF/AE/AWB MeteringPoints are valid."));
            return;
        }
        this.failActionFuture("Cancelled by another startFocusAndMetering()");
        this.failCancelFuture("Cancelled by another startFocusAndMetering()");
        this.disableAutoCancel();
        this.mRunningActionCompleter = completer;
        this.executeMeteringAction(meteringRectanglesListAF.toArray(new MeteringRectangle[0]), meteringRectanglesListAE.toArray(new MeteringRectangle[0]), meteringRectanglesListAWB.toArray(new MeteringRectangle[0]), action);
    }

    private int getDefaultTemplate() {
        return 1;
    }

    void triggerAf(final @Nullable CallbackToFutureAdapter.Completer<CameraCaptureResult> completer) {
        if (!this.mIsActive) {
            if (completer != null) {
                completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
            return;
        }
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setTemplateType(this.getDefaultTemplate());
        builder.setUseRepeatingSurface(true);
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_TRIGGER, 1);
        builder.addImplementationOptions((Config)configBuilder.build());
        builder.addCameraCaptureCallback(new CameraCaptureCallback(){

            public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                if (completer != null) {
                    completer.set((Object)cameraCaptureResult);
                }
            }

            public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
                if (completer != null) {
                    completer.setException((Throwable)new CameraControlInternal.CameraControlException(failure));
                }
            }

            public void onCaptureCancelled() {
                if (completer != null) {
                    completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is closed"));
                }
            }
        });
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    void triggerAePrecapture(final @Nullable CallbackToFutureAdapter.Completer<CameraCaptureResult> completer) {
        if (!this.mIsActive) {
            if (completer != null) {
                completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
            return;
        }
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setTemplateType(this.getDefaultTemplate());
        builder.setUseRepeatingSurface(true);
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 1);
        builder.addImplementationOptions((Config)configBuilder.build());
        builder.addCameraCaptureCallback(new CameraCaptureCallback(){

            public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                if (completer != null) {
                    completer.set((Object)cameraCaptureResult);
                }
            }

            public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
                if (completer != null) {
                    completer.setException((Throwable)new CameraControlInternal.CameraControlException(failure));
                }
            }

            public void onCaptureCancelled() {
                if (completer != null) {
                    completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is closed"));
                }
            }
        });
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    void cancelAfAeTrigger(boolean cancelAfTrigger, boolean cancelAePrecaptureTrigger) {
        if (!this.mIsActive) {
            return;
        }
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setUseRepeatingSurface(true);
        builder.setTemplateType(this.getDefaultTemplate());
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        if (cancelAfTrigger) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_TRIGGER, 2);
        }
        if (Build.VERSION.SDK_INT >= 23 && cancelAePrecaptureTrigger) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 2);
        }
        builder.addImplementationOptions((Config)configBuilder.build());
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    private void disableAutoCancel() {
        if (this.mAutoCancelHandle != null) {
            this.mAutoCancelHandle.cancel(true);
            this.mAutoCancelHandle = null;
        }
    }

    private static int getRegionCount(@Nullable MeteringRectangle[] regions) {
        if (regions == null) {
            return 0;
        }
        return regions.length;
    }

    private static boolean hasEqualRegions(@Nullable MeteringRectangle[] regions1, @Nullable MeteringRectangle[] regions2) {
        if (FocusMeteringControl.getRegionCount(regions1) == 0 && FocusMeteringControl.getRegionCount(regions2) == 0) {
            return true;
        }
        if (FocusMeteringControl.getRegionCount(regions1) != FocusMeteringControl.getRegionCount(regions2)) {
            return false;
        }
        if (regions1 != null && regions2 != null) {
            for (int i = 0; i < regions1.length; ++i) {
                if (regions1[i].equals(regions2[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAfModeSupported() {
        return this.mCameraControl.getSupportedAfMode(1) == 1;
    }

    private void completeActionFuture(boolean isFocusSuccessful) {
        if (this.mRunningActionCompleter != null) {
            this.mRunningActionCompleter.set((Object)FocusMeteringResult.create((boolean)isFocusSuccessful));
            this.mRunningActionCompleter = null;
        }
    }

    private void failActionFuture(String message) {
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForFocus);
        if (this.mRunningActionCompleter != null) {
            this.mRunningActionCompleter.setException((Throwable)new CameraControl.OperationCanceledException(message));
            this.mRunningActionCompleter = null;
        }
    }

    private void failCancelFuture(String message) {
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForCancel);
        if (this.mRunningCancelCompleter != null) {
            this.mRunningCancelCompleter.setException((Throwable)new CameraControl.OperationCanceledException(message));
            this.mRunningCancelCompleter = null;
        }
    }

    private void completeCancelFuture() {
        if (this.mRunningCancelCompleter != null) {
            this.mRunningCancelCompleter.set(null);
            this.mRunningCancelCompleter = null;
        }
    }

    private void executeMeteringAction(@NonNull MeteringRectangle[] afRects, @NonNull MeteringRectangle[] aeRects, @NonNull MeteringRectangle[] awbRects, FocusMeteringAction focusMeteringAction) {
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForFocus);
        this.disableAutoCancel();
        this.mAfRects = afRects;
        this.mAeRects = aeRects;
        this.mAwbRects = awbRects;
        if (this.shouldTriggerAF()) {
            this.mIsInAfAutoMode = true;
            this.mIsAutoFocusCompleted = false;
            this.mIsFocusSuccessful = false;
            this.mCameraControl.updateSessionConfigSynchronous();
            this.triggerAf(null);
        } else {
            this.mIsInAfAutoMode = false;
            this.mIsAutoFocusCompleted = true;
            this.mIsFocusSuccessful = false;
            this.mCameraControl.updateSessionConfigSynchronous();
        }
        this.mCurrentAfState = 0;
        boolean isAfModeSupported = this.isAfModeSupported();
        this.mSessionListenerForFocus = result -> {
            Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
            if (this.shouldTriggerAF()) {
                if (!isAfModeSupported || afState == null) {
                    this.mIsFocusSuccessful = true;
                    this.mIsAutoFocusCompleted = true;
                } else if (this.mCurrentAfState == 3) {
                    if (afState == 4) {
                        this.mIsFocusSuccessful = true;
                        this.mIsAutoFocusCompleted = true;
                    } else if (afState == 5) {
                        this.mIsFocusSuccessful = false;
                        this.mIsAutoFocusCompleted = true;
                    }
                }
            }
            if (this.mIsAutoFocusCompleted && result.getRequest() != null) {
                MeteringRectangle[] toMatchAfRegions = afRects.length != 0 ? afRects : this.mDefaultAfRects;
                MeteringRectangle[] toMatchAeRegions = aeRects.length != 0 ? aeRects : this.mDefaultAeRects;
                MeteringRectangle[] toMatchAwbRegions = awbRects.length != 0 ? awbRects : this.mDefaultAwbRects;
                CaptureRequest request = result.getRequest();
                if (FocusMeteringControl.hasEqualRegions((MeteringRectangle[])request.get(CaptureRequest.CONTROL_AF_REGIONS), toMatchAfRegions) && FocusMeteringControl.hasEqualRegions((MeteringRectangle[])request.get(CaptureRequest.CONTROL_AE_REGIONS), toMatchAeRegions) && FocusMeteringControl.hasEqualRegions((MeteringRectangle[])request.get(CaptureRequest.CONTROL_AWB_REGIONS), toMatchAwbRegions)) {
                    this.completeActionFuture(this.mIsFocusSuccessful);
                    return true;
                }
            }
            if (!this.mCurrentAfState.equals(afState) && afState != null) {
                this.mCurrentAfState = afState;
            }
            return false;
        };
        this.mCameraControl.addCaptureResultListener(this.mSessionListenerForFocus);
        if (focusMeteringAction.isAutoCancelEnabled()) {
            long timeoutId = ++this.mFocusTimeoutCounter;
            Runnable autoCancelRunnable = () -> this.mExecutor.execute(() -> {
                if (timeoutId == this.mFocusTimeoutCounter) {
                    this.cancelFocusAndMeteringWithoutAsyncResult();
                }
            });
            this.mAutoCancelHandle = this.mScheduler.schedule(autoCancelRunnable, focusMeteringAction.getAutoCancelDurationInMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private boolean shouldTriggerAF() {
        return this.mAfRects.length > 0;
    }

    ListenableFuture<Void> cancelFocusAndMetering() {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.cancelFocusAndMeteringInternal((CallbackToFutureAdapter.Completer<Void>)completer));
            return "cancelFocusAndMetering";
        });
    }

    void cancelFocusAndMeteringWithoutAsyncResult() {
        this.cancelFocusAndMeteringInternal(null);
    }

    void cancelFocusAndMeteringInternal(@Nullable CallbackToFutureAdapter.Completer<Void> completer) {
        this.failCancelFuture("Cancelled by another cancelFocusAndMetering()");
        this.failActionFuture("Cancelled by cancelFocusAndMetering()");
        this.mRunningCancelCompleter = completer;
        this.disableAutoCancel();
        if (this.mRunningCancelCompleter != null) {
            int targetAfMode = this.mCameraControl.getSupportedAfMode(4);
            this.mSessionListenerForCancel = captureResult -> {
                Integer afMode = (Integer)captureResult.get(CaptureResult.CONTROL_AF_MODE);
                CaptureRequest request = captureResult.getRequest();
                MeteringRectangle[] afRegions = (MeteringRectangle[])request.get(CaptureRequest.CONTROL_AF_REGIONS);
                MeteringRectangle[] aeRegions = (MeteringRectangle[])request.get(CaptureRequest.CONTROL_AE_REGIONS);
                MeteringRectangle[] awbRegions = (MeteringRectangle[])request.get(CaptureRequest.CONTROL_AWB_REGIONS);
                if (afMode == targetAfMode && FocusMeteringControl.hasEqualRegions(afRegions, this.mDefaultAfRects) && FocusMeteringControl.hasEqualRegions(aeRegions, this.mDefaultAeRects) && FocusMeteringControl.hasEqualRegions(awbRegions, this.mDefaultAwbRects)) {
                    this.completeCancelFuture();
                    return true;
                }
                return false;
            };
            this.mCameraControl.addCaptureResultListener(this.mSessionListenerForCancel);
        }
        if (this.shouldTriggerAF()) {
            this.cancelAfAeTrigger(true, false);
        }
        this.mAfRects = new MeteringRectangle[0];
        this.mAeRects = new MeteringRectangle[0];
        this.mAwbRects = new MeteringRectangle[0];
        this.mIsInAfAutoMode = false;
        this.mCameraControl.updateSessionConfigSynchronous();
    }
}

