/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.os.Build;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.SurfaceConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@RequiresApi(value=21)
public class ExtraCroppingQuirk
implements Quirk {
    private static final List<String> SAMSUNG_DISTORTION_MODELS = Arrays.asList("SM-T580", "SM-J710MN", "SM-A320FL", "SM-G570M", "SM-G610F", "SM-G610M");

    static boolean load() {
        return ExtraCroppingQuirk.isSamsungDistortion();
    }

    @Nullable
    public Size getVerifiedResolution(@NonNull SurfaceConfig.ConfigType configType) {
        if (ExtraCroppingQuirk.isSamsungDistortion()) {
            switch (configType) {
                case PRIV: {
                    return new Size(1920, 1080);
                }
                case YUV: {
                    return new Size(1280, 720);
                }
                case JPEG: {
                    return new Size(3264, 1836);
                }
            }
            return null;
        }
        return null;
    }

    private static boolean isSamsungDistortion() {
        return "samsung".equalsIgnoreCase(Build.BRAND) && SAMSUNG_DISTORTION_MODELS.contains(Build.MODEL.toUpperCase(Locale.US));
    }
}

