/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.OutputConfiguration;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;

public final class ApiCompat {
    private ApiCompat() {
    }

    @RequiresApi(value=29)
    public static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        public static void onCameraAccessPrioritiesChanged(@NonNull CameraManager.AvailabilityCallback callback) {
            callback.onCameraAccessPrioritiesChanged();
        }
    }

    @RequiresApi(value=26)
    public static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        public static void onCaptureQueueEmpty(@NonNull CameraCaptureSession.StateCallback callback, @NonNull CameraCaptureSession session) {
            callback.onCaptureQueueEmpty(session);
        }

        @DoNotInline
        @NonNull
        public static <T> OutputConfiguration newOutputConfiguration(@NonNull Size surfaceSize, @NonNull Class<T> klass) {
            return new OutputConfiguration(surfaceSize, klass);
        }
    }

    @RequiresApi(value=24)
    public static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        public static void onCaptureBufferLost(@NonNull CameraCaptureSession.CaptureCallback callback, @NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull Surface surface, long frame) {
            callback.onCaptureBufferLost(session, request, surface, frame);
        }
    }

    @RequiresApi(value=23)
    public static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        public static void onSurfacePrepared(@NonNull CameraCaptureSession.StateCallback callback, @NonNull CameraCaptureSession session, @NonNull Surface surface) {
            callback.onSurfacePrepared(session, surface);
        }
    }

    @RequiresApi(value=21)
    public static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        public static void close(@NonNull CameraDevice cameraDevice) {
            cameraDevice.close();
        }
    }
}

