/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsApi28Impl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsBaseImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
public class CameraCharacteristicsCompat {
    @NonNull
    @GuardedBy(value="this")
    private final Map<CameraCharacteristics.Key<?>, Object> mValuesCache = new HashMap();
    @NonNull
    private final CameraCharacteristicsCompatImpl mCameraCharacteristicsImpl;

    private CameraCharacteristicsCompat(@NonNull CameraCharacteristics cameraCharacteristics) {
        this.mCameraCharacteristicsImpl = Build.VERSION.SDK_INT >= 28 ? new CameraCharacteristicsApi28Impl(cameraCharacteristics) : new CameraCharacteristicsBaseImpl(cameraCharacteristics);
    }

    @VisibleForTesting(otherwise=3)
    @NonNull
    public static CameraCharacteristicsCompat toCameraCharacteristicsCompat(@NonNull CameraCharacteristics characteristics) {
        return new CameraCharacteristicsCompat(characteristics);
    }

    private boolean isKeyNonCacheable(@NonNull CameraCharacteristics.Key<?> key) {
        return key.equals((Object)CameraCharacteristics.SENSOR_ORIENTATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T get(@NonNull CameraCharacteristics.Key<T> key) {
        if (this.isKeyNonCacheable(key)) {
            return this.mCameraCharacteristicsImpl.get(key);
        }
        CameraCharacteristicsCompat cameraCharacteristicsCompat = this;
        synchronized (cameraCharacteristicsCompat) {
            Object value = this.mValuesCache.get(key);
            if (value != null) {
                return (T)value;
            }
            value = this.mCameraCharacteristicsImpl.get(key);
            if (value != null) {
                this.mValuesCache.put(key, value);
            }
            return (T)value;
        }
    }

    @NonNull
    public Set<String> getPhysicalCameraIds() {
        return this.mCameraCharacteristicsImpl.getPhysicalCameraIds();
    }

    @NonNull
    public CameraCharacteristics toCameraCharacteristics() {
        return this.mCameraCharacteristicsImpl.unwrap();
    }

    public static interface CameraCharacteristicsCompatImpl {
        @Nullable
        public <T> T get(@NonNull CameraCharacteristics.Key<T> var1);

        @NonNull
        public Set<String> getPhysicalCameraIds();

        @NonNull
        public CameraCharacteristics unwrap();
    }
}

