/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.ApiCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
class CameraBurstCaptureCallback
extends CameraCaptureSession.CaptureCallback {
    final Map<CaptureRequest, List<CameraCaptureSession.CaptureCallback>> mCallbackMap = new HashMap<CaptureRequest, List<CameraCaptureSession.CaptureCallback>>();
    CaptureSequenceCallback mCaptureSequenceCallback = null;

    CameraBurstCaptureCallback() {
    }

    @RequiresApi(api=24)
    public void onCaptureBufferLost(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull Surface surface, long frame) {
        for (CameraCaptureSession.CaptureCallback callback : this.getCallbacks(request)) {
            ApiCompat.Api24Impl.onCaptureBufferLost(callback, session, request, surface, frame);
        }
    }

    public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        for (CameraCaptureSession.CaptureCallback callback : this.getCallbacks(request)) {
            callback.onCaptureCompleted(session, request, result);
        }
    }

    public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
        for (CameraCaptureSession.CaptureCallback callback : this.getCallbacks(request)) {
            callback.onCaptureFailed(session, request, failure);
        }
    }

    public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
        for (CameraCaptureSession.CaptureCallback callback : this.getCallbacks(request)) {
            callback.onCaptureProgressed(session, request, partialResult);
        }
    }

    public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
        for (CameraCaptureSession.CaptureCallback callback : this.getCallbacks(request)) {
            callback.onCaptureStarted(session, request, timestamp, frameNumber);
        }
    }

    public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
        for (List<CameraCaptureSession.CaptureCallback> callbackList : this.mCallbackMap.values()) {
            for (CameraCaptureSession.CaptureCallback callback : callbackList) {
                callback.onCaptureSequenceAborted(session, sequenceId);
            }
        }
        if (this.mCaptureSequenceCallback != null) {
            this.mCaptureSequenceCallback.onCaptureSequenceCompletedOrAborted(session, sequenceId, true);
        }
    }

    public void onCaptureSequenceCompleted(@NonNull CameraCaptureSession session, int sequenceId, long frameNumber) {
        for (List<CameraCaptureSession.CaptureCallback> callbackList : this.mCallbackMap.values()) {
            for (CameraCaptureSession.CaptureCallback callback : callbackList) {
                callback.onCaptureSequenceCompleted(session, sequenceId, frameNumber);
            }
        }
        if (this.mCaptureSequenceCallback != null) {
            this.mCaptureSequenceCallback.onCaptureSequenceCompletedOrAborted(session, sequenceId, false);
        }
    }

    private List<CameraCaptureSession.CaptureCallback> getCallbacks(CaptureRequest request) {
        List<CameraCaptureSession.CaptureCallback> callbacks = this.mCallbackMap.get(request);
        return callbacks != null ? callbacks : Collections.emptyList();
    }

    void addCamera2Callbacks(CaptureRequest captureRequest, List<CameraCaptureSession.CaptureCallback> captureCallbacks) {
        List<CameraCaptureSession.CaptureCallback> existingCallbacks = this.mCallbackMap.get(captureRequest);
        if (existingCallbacks != null) {
            ArrayList<CameraCaptureSession.CaptureCallback> totalCallbacks = new ArrayList<CameraCaptureSession.CaptureCallback>(captureCallbacks.size() + existingCallbacks.size());
            totalCallbacks.addAll(captureCallbacks);
            totalCallbacks.addAll(existingCallbacks);
            this.mCallbackMap.put(captureRequest, totalCallbacks);
        } else {
            this.mCallbackMap.put(captureRequest, captureCallbacks);
        }
    }

    public void setCaptureSequenceCallback(@NonNull CaptureSequenceCallback callback) {
        this.mCaptureSequenceCallback = callback;
    }

    static interface CaptureSequenceCallback {
        public void onCaptureSequenceCompletedOrAborted(@NonNull CameraCaptureSession var1, int var2, boolean var3);
    }
}

