/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.Camera2CameraImpl;
import androidx.camera.camera2.internal.Camera2CameraInfoImpl;
import androidx.camera.camera2.internal.CameraSelectionOptimizer;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.concurrent.Camera2CameraCoordinator;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.InitializationException;
import androidx.camera.core.Logger;
import androidx.camera.core.concurrent.CameraCoordinator;
import androidx.camera.core.impl.CameraFactory;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CameraStateRegistry;
import androidx.camera.core.impl.CameraThreadConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
public final class Camera2CameraFactory
implements CameraFactory {
    private static final String TAG = "Camera2CameraFactory";
    private static final int DEFAULT_ALLOWED_CONCURRENT_OPEN_CAMERAS = 1;
    private final CameraCoordinator mCameraCoordinator;
    private final CameraThreadConfig mThreadConfig;
    private final CameraStateRegistry mCameraStateRegistry;
    private final CameraManagerCompat mCameraManager;
    private final List<String> mAvailableCameraIds;
    private final DisplayInfoManager mDisplayInfoManager;
    private final Map<String, Camera2CameraInfoImpl> mCameraInfos = new HashMap<String, Camera2CameraInfoImpl>();

    public Camera2CameraFactory(@NonNull Context context, @NonNull CameraThreadConfig threadConfig, @Nullable CameraSelector availableCamerasSelector) throws InitializationException {
        this.mThreadConfig = threadConfig;
        this.mCameraManager = CameraManagerCompat.from(context, this.mThreadConfig.getSchedulerHandler());
        this.mDisplayInfoManager = DisplayInfoManager.getInstance(context);
        List<String> optimizedCameraIds = CameraSelectionOptimizer.getSelectedAvailableCameraIds(this, availableCamerasSelector);
        this.mAvailableCameraIds = this.getBackwardCompatibleCameraIds(optimizedCameraIds);
        this.mCameraCoordinator = new Camera2CameraCoordinator(this.mCameraManager);
        this.mCameraStateRegistry = new CameraStateRegistry(this.mCameraCoordinator, 1);
        this.mCameraCoordinator.addListener((CameraCoordinator.ConcurrentCameraModeListener)this.mCameraStateRegistry);
    }

    @NonNull
    public CameraInternal getCamera(@NonNull String cameraId) throws CameraUnavailableException {
        if (!this.mAvailableCameraIds.contains(cameraId)) {
            throw new IllegalArgumentException("The given camera id is not on the available camera id list.");
        }
        return new Camera2CameraImpl(this.mCameraManager, cameraId, this.getCameraInfo(cameraId), this.mCameraCoordinator, this.mCameraStateRegistry, this.mThreadConfig.getCameraExecutor(), this.mThreadConfig.getSchedulerHandler(), this.mDisplayInfoManager);
    }

    Camera2CameraInfoImpl getCameraInfo(@NonNull String cameraId) throws CameraUnavailableException {
        try {
            Camera2CameraInfoImpl camera2CameraInfoImpl = this.mCameraInfos.get(cameraId);
            if (camera2CameraInfoImpl == null) {
                camera2CameraInfoImpl = new Camera2CameraInfoImpl(cameraId, this.mCameraManager);
                this.mCameraInfos.put(cameraId, camera2CameraInfoImpl);
            }
            return camera2CameraInfoImpl;
        }
        catch (CameraAccessExceptionCompat e) {
            throw CameraUnavailableExceptionHelper.createFrom(e);
        }
    }

    @NonNull
    public Set<String> getAvailableCameraIds() {
        return new LinkedHashSet<String>(this.mAvailableCameraIds);
    }

    @NonNull
    public CameraCoordinator getCameraCoordinator() {
        return this.mCameraCoordinator;
    }

    @NonNull
    public CameraManagerCompat getCameraManager() {
        return this.mCameraManager;
    }

    private List<String> getBackwardCompatibleCameraIds(@NonNull List<String> availableCameraIds) throws InitializationException {
        ArrayList<String> backwardCompatibleCameraIds = new ArrayList<String>();
        for (String cameraId : availableCameraIds) {
            if (cameraId.equals("0") || cameraId.equals("1")) {
                backwardCompatibleCameraIds.add(cameraId);
                continue;
            }
            if (this.isBackwardCompatible(cameraId)) {
                backwardCompatibleCameraIds.add(cameraId);
                continue;
            }
            Logger.d((String)TAG, (String)("Camera " + cameraId + " is filtered out because its capabilities do not contain REQUEST_AVAILABLE_CAPABILITIES_BACKWARD_COMPATIBLE."));
        }
        return backwardCompatibleCameraIds;
    }

    private boolean isBackwardCompatible(@NonNull String cameraId) throws InitializationException {
        int[] availableCapabilities;
        if ("robolectric".equals(Build.FINGERPRINT)) {
            return true;
        }
        try {
            availableCapabilities = (int[])this.mCameraManager.getCameraCharacteristicsCompat(cameraId).get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        }
        catch (CameraAccessExceptionCompat e) {
            throw new InitializationException((Throwable)CameraUnavailableExceptionHelper.createFrom(e));
        }
        if (availableCapabilities != null) {
            for (int capability : availableCapabilities) {
                if (capability != 0) continue;
                return true;
            }
        }
        return false;
    }
}

