/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.CaptureCallbackContainer;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfig;
import java.util.Collection;

@RequiresApi(value=21)
class Camera2CaptureOptionUnpacker
implements CaptureConfig.OptionUnpacker {
    static final Camera2CaptureOptionUnpacker INSTANCE = new Camera2CaptureOptionUnpacker();

    Camera2CaptureOptionUnpacker() {
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    public void unpack(@NonNull UseCaseConfig<?> config, @NonNull CaptureConfig.Builder builder) {
        CaptureConfig defaultCaptureConfig = config.getDefaultCaptureConfig(null);
        OptionsBundle implOptions = OptionsBundle.emptyBundle();
        int templateType = CaptureConfig.defaultEmptyCaptureConfig().getTemplateType();
        if (defaultCaptureConfig != null) {
            templateType = defaultCaptureConfig.getTemplateType();
            builder.addAllCameraCaptureCallbacks((Collection)defaultCaptureConfig.getCameraCaptureCallbacks());
            implOptions = defaultCaptureConfig.getImplementationOptions();
        }
        builder.setImplementationOptions((Config)implOptions);
        Camera2ImplConfig camera2Config = new Camera2ImplConfig((Config)config);
        builder.setTemplateType(camera2Config.getCaptureRequestTemplate(templateType));
        builder.addCameraCaptureCallback((CameraCaptureCallback)CaptureCallbackContainer.create(camera2Config.getSessionCaptureCallback(Camera2CaptureCallbacks.createNoOpCallback())));
        builder.addImplementationOptions((Config)camera2Config.getCaptureRequestOptions());
    }
}

