/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.core.CameraState;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CameraStateRegistry;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.util.Objects;

@RequiresApi(value=21)
class CameraStateMachine {
    private static final String TAG = "CameraStateMachine";
    @NonNull
    private final CameraStateRegistry mCameraStateRegistry;
    @NonNull
    private final MutableLiveData<CameraState> mCameraStates;

    CameraStateMachine(@NonNull CameraStateRegistry cameraStateRegistry) {
        this.mCameraStateRegistry = cameraStateRegistry;
        this.mCameraStates = new MutableLiveData();
        this.mCameraStates.postValue((Object)CameraState.create((CameraState.Type)CameraState.Type.CLOSED));
    }

    public void updateState(@NonNull CameraInternal.State newInternalState, @Nullable CameraState.StateError stateError) {
        CameraState newPublicState;
        switch (newInternalState) {
            case PENDING_OPEN: {
                newPublicState = this.onCameraPendingOpen();
                break;
            }
            case OPENING: {
                newPublicState = CameraState.create((CameraState.Type)CameraState.Type.OPENING, (CameraState.StateError)stateError);
                break;
            }
            case OPEN: 
            case CONFIGURED: {
                newPublicState = CameraState.create((CameraState.Type)CameraState.Type.OPEN, (CameraState.StateError)stateError);
                break;
            }
            case CLOSING: 
            case RELEASING: {
                newPublicState = CameraState.create((CameraState.Type)CameraState.Type.CLOSING, (CameraState.StateError)stateError);
                break;
            }
            case CLOSED: 
            case RELEASED: {
                newPublicState = CameraState.create((CameraState.Type)CameraState.Type.CLOSED, (CameraState.StateError)stateError);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown internal camera state: " + newInternalState);
            }
        }
        Logger.d((String)TAG, (String)("New public camera state " + newPublicState + " from " + newInternalState + " and " + stateError));
        CameraState currentPublicState = (CameraState)this.mCameraStates.getValue();
        if (!Objects.equals(currentPublicState, newPublicState)) {
            Logger.d((String)TAG, (String)("Publishing new public camera state " + newPublicState));
            this.mCameraStates.postValue((Object)newPublicState);
        }
    }

    private CameraState onCameraPendingOpen() {
        return this.mCameraStateRegistry.isCameraClosing() ? CameraState.create((CameraState.Type)CameraState.Type.OPENING) : CameraState.create((CameraState.Type)CameraState.Type.PENDING_OPEN);
    }

    @NonNull
    public LiveData<CameraState> getStateLiveData() {
        return this.mCameraStates;
    }
}

