/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.params;

import android.hardware.camera2.params.DynamicRangeProfiles;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.params.DynamicRangeConversions;
import androidx.camera.camera2.internal.compat.params.DynamicRangesCompat;
import androidx.camera.core.DynamicRange;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@RequiresApi(value=33)
class DynamicRangesCompatApi33Impl
implements DynamicRangesCompat.DynamicRangeProfilesCompatImpl {
    private final DynamicRangeProfiles mDynamicRangeProfiles;

    DynamicRangesCompatApi33Impl(@NonNull Object dynamicRangeProfiles) {
        this.mDynamicRangeProfiles = (DynamicRangeProfiles)dynamicRangeProfiles;
    }

    @Override
    @NonNull
    public Set<DynamicRange> getDynamicRangeCaptureRequestConstraints(@NonNull DynamicRange dynamicRange) {
        Long dynamicRangeProfile = this.dynamicRangeToFirstSupportedProfile(dynamicRange);
        Preconditions.checkArgument((dynamicRangeProfile != null ? 1 : 0) != 0, (Object)("DynamicRange is not supported: " + dynamicRange));
        return DynamicRangesCompatApi33Impl.profileSetToDynamicRangeSet(this.mDynamicRangeProfiles.getProfileCaptureRequestConstraints(dynamicRangeProfile.longValue()));
    }

    @Override
    @NonNull
    public Set<DynamicRange> getSupportedDynamicRanges() {
        return DynamicRangesCompatApi33Impl.profileSetToDynamicRangeSet(this.mDynamicRangeProfiles.getSupportedProfiles());
    }

    @Override
    public boolean isExtraLatencyPresent(@NonNull DynamicRange dynamicRange) {
        Long dynamicRangeProfile = this.dynamicRangeToFirstSupportedProfile(dynamicRange);
        Preconditions.checkArgument((dynamicRangeProfile != null ? 1 : 0) != 0, (Object)("DynamicRange is not supported: " + dynamicRange));
        return this.mDynamicRangeProfiles.isExtraLatencyPresent(dynamicRangeProfile.longValue());
    }

    @Override
    @Nullable
    public DynamicRangeProfiles unwrap() {
        return this.mDynamicRangeProfiles;
    }

    @NonNull
    private static DynamicRange profileToDynamicRange(long profile) {
        return (DynamicRange)Preconditions.checkNotNull((Object)DynamicRangeConversions.profileToDynamicRange(profile), (Object)("Dynamic range profile cannot be converted to a DynamicRange object: " + profile));
    }

    @Nullable
    private Long dynamicRangeToFirstSupportedProfile(@NonNull DynamicRange dynamicRange) {
        return DynamicRangeConversions.dynamicRangeToFirstSupportedProfile(dynamicRange, this.mDynamicRangeProfiles);
    }

    @NonNull
    private static Set<DynamicRange> profileSetToDynamicRangeSet(@NonNull Set<Long> profileSet) {
        if (profileSet.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DynamicRange> dynamicRangeSet = new HashSet<DynamicRange>(profileSet.size());
        for (long profile : profileSet) {
            dynamicRangeSet.add(DynamicRangesCompatApi33Impl.profileToDynamicRange(profile));
        }
        return Collections.unmodifiableSet(dynamicRangeSet);
    }
}

