/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.params;

import android.hardware.camera2.params.OutputConfiguration;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompatApi26Impl;
import androidx.core.util.Preconditions;
import java.util.Objects;

@RequiresApi(value=28)
class OutputConfigurationCompatApi28Impl
extends OutputConfigurationCompatApi26Impl {
    OutputConfigurationCompatApi28Impl(@NonNull Surface surface) {
        this(new OutputConfigurationParamsApi28(new OutputConfiguration(surface)));
    }

    OutputConfigurationCompatApi28Impl(int surfaceGroupId, @NonNull Surface surface) {
        this(new OutputConfigurationParamsApi28(new OutputConfiguration(surfaceGroupId, surface)));
    }

    OutputConfigurationCompatApi28Impl(@NonNull Object outputConfiguration) {
        super(outputConfiguration);
    }

    @RequiresApi(value=28)
    static OutputConfigurationCompatApi28Impl wrap(@NonNull OutputConfiguration outputConfiguration) {
        return new OutputConfigurationCompatApi28Impl(new OutputConfigurationParamsApi28(outputConfiguration));
    }

    @Override
    public void removeSurface(@NonNull Surface surface) {
        ((OutputConfiguration)this.getOutputConfiguration()).removeSurface(surface);
    }

    @Override
    public int getMaxSharedSurfaceCount() {
        return ((OutputConfiguration)this.getOutputConfiguration()).getMaxSharedSurfaceCount();
    }

    @Override
    public void setPhysicalCameraId(@Nullable String physicalCameraId) {
        ((OutputConfiguration)this.getOutputConfiguration()).setPhysicalCameraId(physicalCameraId);
    }

    @Override
    @Nullable
    public String getPhysicalCameraId() {
        return null;
    }

    @Override
    public long getDynamicRangeProfile() {
        return ((OutputConfigurationParamsApi28)this.mObject).mDynamicRangeProfile;
    }

    @Override
    public void setDynamicRangeProfile(long profile) {
        ((OutputConfigurationParamsApi28)this.mObject).mDynamicRangeProfile = profile;
    }

    @Override
    @NonNull
    public Object getOutputConfiguration() {
        Preconditions.checkArgument((boolean)(this.mObject instanceof OutputConfigurationParamsApi28));
        return ((OutputConfigurationParamsApi28)this.mObject).mOutputConfiguration;
    }

    private static final class OutputConfigurationParamsApi28 {
        @NonNull
        final OutputConfiguration mOutputConfiguration;
        long mDynamicRangeProfile = 1L;

        OutputConfigurationParamsApi28(@NonNull OutputConfiguration configuration) {
            this.mOutputConfiguration = configuration;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OutputConfigurationParamsApi28)) {
                return false;
            }
            OutputConfigurationParamsApi28 otherOutputConfig = (OutputConfigurationParamsApi28)obj;
            return Objects.equals(this.mOutputConfiguration, otherOutputConfig.mOutputConfiguration) && this.mDynamicRangeProfile == otherOutputConfig.mDynamicRangeProfile;
        }

        public int hashCode() {
            int h = 1;
            h = (h << 5) - h ^ this.mOutputConfiguration.hashCode();
            h = (h << 5) - h ^ Long.hashCode(this.mDynamicRangeProfile);
            return h;
        }
    }
}

