/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.quirk;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.quirk.UseTorchAsFlashQuirk;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@RequiresApi(value=21)
public class FlashTooSlowQuirk
implements UseTorchAsFlashQuirk {
    private static final List<String> AFFECTED_MODEL_PREFIXES = Arrays.asList("PIXEL 3A", "PIXEL 3A XL", "PIXEL 4", "PIXEL 5", "SM-A320");

    static boolean load(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        return FlashTooSlowQuirk.isAffectedModel() && (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 1;
    }

    private static boolean isAffectedModel() {
        for (String modelPrefix : AFFECTED_MODEL_PREFIXES) {
            if (!Build.MODEL.toUpperCase(Locale.US).startsWith(modelPrefix)) continue;
            return true;
        }
        return false;
    }
}

