/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.Camera2CaptureCallbacks;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.camera2.internal.compat.quirk.CaptureSessionStuckQuirk;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;

@RequiresApi(value=21)
public class WaitForRepeatingRequestStart {
    private final boolean mHasCaptureSessionStuckQuirk;
    private final Object mLock = new Object();
    @NonNull
    private final ListenableFuture<Void> mStartStreamingFuture;
    CallbackToFutureAdapter.Completer<Void> mStartStreamingCompleter;
    private boolean mHasSubmittedRepeating;
    private final CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureStarted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, long timestamp, long frameNumber) {
            if (WaitForRepeatingRequestStart.this.mStartStreamingCompleter != null) {
                WaitForRepeatingRequestStart.this.mStartStreamingCompleter.set(null);
                WaitForRepeatingRequestStart.this.mStartStreamingCompleter = null;
            }
        }

        public void onCaptureSequenceAborted(@NonNull CameraCaptureSession session, int sequenceId) {
            if (WaitForRepeatingRequestStart.this.mStartStreamingCompleter != null) {
                WaitForRepeatingRequestStart.this.mStartStreamingCompleter.setCancelled();
                WaitForRepeatingRequestStart.this.mStartStreamingCompleter = null;
            }
        }
    };

    public WaitForRepeatingRequestStart(@NonNull Quirks cameraQuirks) {
        this.mHasCaptureSessionStuckQuirk = cameraQuirks.contains(CaptureSessionStuckQuirk.class);
        this.mStartStreamingFuture = this.shouldWaitRepeatingSubmit() ? CallbackToFutureAdapter.getFuture(completer -> {
            this.mStartStreamingCompleter = completer;
            return "WaitForRepeatingRequestStart[" + this + "]";
        }) : Futures.immediateFuture(null);
    }

    public boolean shouldWaitRepeatingSubmit() {
        return this.mHasCaptureSessionStuckQuirk;
    }

    @NonNull
    public ListenableFuture<Void> getStartStreamFuture() {
        return Futures.nonCancellationPropagating(this.mStartStreamingFuture);
    }

    @NonNull
    public ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice cameraDevice, @NonNull SessionConfigurationCompat sessionConfigurationCompat, @NonNull List<DeferrableSurface> deferrableSurfaces, @NonNull List<SynchronizedCaptureSession> closingSessions, @NonNull OpenCaptureSession openCaptureSession) {
        ArrayList<ListenableFuture<Void>> futureList = new ArrayList<ListenableFuture<Void>>();
        for (SynchronizedCaptureSession session : closingSessions) {
            futureList.add(session.getOpeningBlocker());
        }
        return FutureChain.from((ListenableFuture)Futures.successfulAsList(futureList)).transformAsync(v -> openCaptureSession.run(cameraDevice, sessionConfigurationCompat, deferrableSurfaces), CameraXExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull CameraCaptureSession.CaptureCallback listener, @NonNull SingleRepeatingRequest singleRepeatingRequest) throws CameraAccessException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.shouldWaitRepeatingSubmit()) {
                listener = Camera2CaptureCallbacks.createComboCallback(this.mCaptureCallback, listener);
                this.mHasSubmittedRepeating = true;
            }
            return singleRepeatingRequest.run(request, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionEnd() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.shouldWaitRepeatingSubmit() && !this.mHasSubmittedRepeating) {
                this.mStartStreamingFuture.cancel(true);
            }
        }
    }

    @FunctionalInterface
    public static interface OpenCaptureSession {
        @NonNull
        public ListenableFuture<Void> run(@NonNull CameraDevice var1, @NonNull SessionConfigurationCompat var2, @NonNull List<DeferrableSurface> var3);
    }

    @FunctionalInterface
    public static interface SingleRepeatingRequest {
        public int run(@NonNull CaptureRequest var1, @NonNull CameraCaptureSession.CaptureCallback var2) throws CameraAccessException;
    }
}

