/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.media.CamcorderProfile;
import android.util.Pair;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RequiresApi(value=21)
public final class Camera2DeviceSurfaceManager
implements CameraDeviceSurfaceManager {
    private static final String TAG = "Camera2DeviceSurfaceManager";
    private final Map<String, SupportedSurfaceCombination> mCameraSupportedSurfaceCombinationMap = new HashMap<String, SupportedSurfaceCombination>();
    private final CamcorderProfileHelper mCamcorderProfileHelper;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Camera2DeviceSurfaceManager(@NonNull Context context, @Nullable Object cameraManager, @NonNull Set<String> availableCameraIds) throws CameraUnavailableException {
        this(context, new CamcorderProfileHelper(){

            @Override
            public boolean hasProfile(int cameraId, int quality) {
                return CamcorderProfile.hasProfile((int)cameraId, (int)quality);
            }

            @Override
            public CamcorderProfile get(int cameraId, int quality) {
                return CamcorderProfile.get((int)cameraId, (int)quality);
            }
        }, cameraManager, availableCameraIds);
    }

    Camera2DeviceSurfaceManager(@NonNull Context context, @NonNull CamcorderProfileHelper camcorderProfileHelper, @Nullable Object cameraManager, @NonNull Set<String> availableCameraIds) throws CameraUnavailableException {
        Preconditions.checkNotNull((Object)camcorderProfileHelper);
        this.mCamcorderProfileHelper = camcorderProfileHelper;
        CameraManagerCompat cameraManagerCompat = cameraManager instanceof CameraManagerCompat ? (CameraManagerCompat)cameraManager : CameraManagerCompat.from(context);
        this.init(context, cameraManagerCompat, availableCameraIds);
    }

    private void init(@NonNull Context context, @NonNull CameraManagerCompat cameraManager, @NonNull Set<String> availableCameraIds) throws CameraUnavailableException {
        Preconditions.checkNotNull((Object)context);
        for (String cameraId : availableCameraIds) {
            this.mCameraSupportedSurfaceCombinationMap.put(cameraId, new SupportedSurfaceCombination(context, cameraId, cameraManager, this.mCamcorderProfileHelper));
        }
    }

    @Nullable
    public SurfaceConfig transformSurfaceConfig(int cameraMode, @NonNull String cameraId, int imageFormat, @NonNull Size size) {
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        SurfaceConfig surfaceConfig = null;
        if (supportedSurfaceCombination != null) {
            surfaceConfig = supportedSurfaceCombination.transformSurfaceConfig(cameraMode, imageFormat, size);
        }
        return surfaceConfig;
    }

    @NonNull
    public Pair<Map<UseCaseConfig<?>, StreamSpec>, Map<AttachedSurfaceInfo, StreamSpec>> getSuggestedStreamSpecs(int cameraMode, @NonNull String cameraId, @NonNull List<AttachedSurfaceInfo> existingSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap) {
        Preconditions.checkArgument((!newUseCaseConfigsSupportedSizeMap.isEmpty() ? 1 : 0) != 0, (Object)"No new use cases to be bound.");
        SupportedSurfaceCombination supportedSurfaceCombination = this.mCameraSupportedSurfaceCombinationMap.get(cameraId);
        if (supportedSurfaceCombination == null) {
            throw new IllegalArgumentException("No such camera id in supported combination list: " + cameraId);
        }
        return supportedSurfaceCombination.getSuggestedStreamSpecifications(cameraMode, existingSurfaces, newUseCaseConfigsSupportedSizeMap);
    }
}

