/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.AutoValue_SupportedSurfaceCombination_FeatureSettings;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.DynamicRangeResolver;
import androidx.camera.camera2.internal.GuaranteedConfigurationsUtil;
import androidx.camera.camera2.internal.StreamUseCaseUtil;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.StreamConfigurationMapCompat;
import androidx.camera.camera2.internal.compat.workaround.ExtraSupportedSurfaceCombinationsContainer;
import androidx.camera.camera2.internal.compat.workaround.ResolutionCorrector;
import androidx.camera.camera2.internal.compat.workaround.TargetAspectRatio;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraMode;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@OptIn(markerClass={ExperimentalCamera2Interop.class})
@RequiresApi(value=21)
final class SupportedSurfaceCombination {
    private static final String TAG = "SupportedSurfaceCombination";
    private final List<SurfaceCombination> mSurfaceCombinations = new ArrayList<SurfaceCombination>();
    private final List<SurfaceCombination> mUltraHighSurfaceCombinations = new ArrayList<SurfaceCombination>();
    private final List<SurfaceCombination> mConcurrentSurfaceCombinations = new ArrayList<SurfaceCombination>();
    private final Map<FeatureSettings, List<SurfaceCombination>> mFeatureSettingsToSupportedCombinationsMap = new HashMap<FeatureSettings, List<SurfaceCombination>>();
    private final List<SurfaceCombination> mSurfaceCombinations10Bit = new ArrayList<SurfaceCombination>();
    private final List<SurfaceCombination> mSurfaceCombinationsStreamUseCase = new ArrayList<SurfaceCombination>();
    private final String mCameraId;
    private final CamcorderProfileHelper mCamcorderProfileHelper;
    private final CameraCharacteristicsCompat mCharacteristics;
    private final ExtraSupportedSurfaceCombinationsContainer mExtraSupportedSurfaceCombinationsContainer;
    private final int mHardwareLevel;
    private boolean mIsRawSupported = false;
    private boolean mIsBurstCaptureSupported = false;
    private boolean mIsConcurrentCameraModeSupported = false;
    private boolean mIsStreamUseCaseSupported = false;
    private boolean mIsUltraHighResolutionSensorSupported = false;
    @VisibleForTesting
    SurfaceSizeDefinition mSurfaceSizeDefinition;
    List<Integer> mSurfaceSizeDefinitionFormats = new ArrayList<Integer>();
    @NonNull
    private final DisplayInfoManager mDisplayInfoManager;
    private final TargetAspectRatio mTargetAspectRatio = new TargetAspectRatio();
    private final ResolutionCorrector mResolutionCorrector = new ResolutionCorrector();
    private final DynamicRangeResolver mDynamicRangeResolver;

    SupportedSurfaceCombination(@NonNull Context context, @NonNull String cameraId, @NonNull CameraManagerCompat cameraManagerCompat, @NonNull CamcorderProfileHelper camcorderProfileHelper) throws CameraUnavailableException {
        this.mCameraId = (String)Preconditions.checkNotNull((Object)cameraId);
        this.mCamcorderProfileHelper = (CamcorderProfileHelper)Preconditions.checkNotNull((Object)camcorderProfileHelper);
        this.mExtraSupportedSurfaceCombinationsContainer = new ExtraSupportedSurfaceCombinationsContainer();
        this.mDisplayInfoManager = DisplayInfoManager.getInstance(context);
        try {
            this.mCharacteristics = cameraManagerCompat.getCameraCharacteristicsCompat(this.mCameraId);
            Integer keyValue = (Integer)this.mCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            this.mHardwareLevel = keyValue != null ? keyValue : 2;
        }
        catch (CameraAccessExceptionCompat e) {
            throw CameraUnavailableExceptionHelper.createFrom(e);
        }
        int[] availableCapabilities = (int[])this.mCharacteristics.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        if (availableCapabilities != null) {
            for (int capability : availableCapabilities) {
                if (capability == 3) {
                    this.mIsRawSupported = true;
                    continue;
                }
                if (capability == 6) {
                    this.mIsBurstCaptureSupported = true;
                    continue;
                }
                if (Build.VERSION.SDK_INT < 31 || capability != 16) continue;
                this.mIsUltraHighResolutionSensorSupported = true;
            }
        }
        this.mDynamicRangeResolver = new DynamicRangeResolver(this.mCharacteristics);
        this.generateSupportedCombinationList();
        if (this.mIsUltraHighResolutionSensorSupported) {
            this.generateUltraHighSupportedCombinationList();
        }
        this.mIsConcurrentCameraModeSupported = context.getPackageManager().hasSystemFeature("android.hardware.camera.concurrent");
        if (this.mIsConcurrentCameraModeSupported) {
            this.generateConcurrentSupportedCombinationList();
        }
        if (this.mDynamicRangeResolver.is10BitDynamicRangeSupported()) {
            this.generate10BitSupportedCombinationList();
        }
        this.mIsStreamUseCaseSupported = StreamUseCaseUtil.isStreamUseCaseSupported(this.mCharacteristics);
        if (this.mIsStreamUseCaseSupported) {
            this.generateStreamUseCaseSupportedCombinationList();
        }
        this.generateSurfaceSizeDefinition();
        this.checkCustomization();
    }

    String getCameraId() {
        return this.mCameraId;
    }

    boolean isRawSupported() {
        return this.mIsRawSupported;
    }

    boolean isBurstCaptureSupported() {
        return this.mIsBurstCaptureSupported;
    }

    boolean checkSupported(@NonNull FeatureSettings featureSettings, List<SurfaceConfig> surfaceConfigList) {
        SurfaceCombination surfaceCombination;
        boolean isSupported = false;
        Iterator<SurfaceCombination> iterator = this.getSurfaceCombinationsByFeatureSettings(featureSettings).iterator();
        while (iterator.hasNext() && !(isSupported = (surfaceCombination = iterator.next()).getOrderedSupportedSurfaceConfigList(surfaceConfigList) != null)) {
        }
        return isSupported;
    }

    @Nullable
    List<SurfaceConfig> getOrderedSupportedStreamUseCaseSurfaceConfigList(@NonNull FeatureSettings featureSettings, List<SurfaceConfig> surfaceConfigList) {
        if (!StreamUseCaseUtil.shouldUseStreamUseCase(featureSettings)) {
            return null;
        }
        for (SurfaceCombination surfaceCombination : this.mSurfaceCombinationsStreamUseCase) {
            List orderedSurfaceConfigList = surfaceCombination.getOrderedSupportedSurfaceConfigList(surfaceConfigList);
            if (orderedSurfaceConfigList == null) continue;
            return orderedSurfaceConfigList;
        }
        return null;
    }

    private List<SurfaceCombination> getSurfaceCombinationsByFeatureSettings(@NonNull FeatureSettings featureSettings) {
        if (this.mFeatureSettingsToSupportedCombinationsMap.containsKey(featureSettings)) {
            return this.mFeatureSettingsToSupportedCombinationsMap.get(featureSettings);
        }
        List<Object> supportedSurfaceCombinations = new ArrayList<SurfaceCombination>();
        if (featureSettings.getRequiredMaxBitDepth() == 8) {
            switch (featureSettings.getCameraMode()) {
                case 1: {
                    supportedSurfaceCombinations = this.mConcurrentSurfaceCombinations;
                    break;
                }
                case 2: {
                    supportedSurfaceCombinations.addAll(this.mUltraHighSurfaceCombinations);
                    supportedSurfaceCombinations.addAll(this.mSurfaceCombinations);
                    break;
                }
                default: {
                    supportedSurfaceCombinations.addAll(this.mSurfaceCombinations);
                    break;
                }
            }
        } else if (featureSettings.getRequiredMaxBitDepth() == 10 && featureSettings.getCameraMode() == 0) {
            supportedSurfaceCombinations.addAll(this.mSurfaceCombinations10Bit);
        }
        this.mFeatureSettingsToSupportedCombinationsMap.put(featureSettings, supportedSurfaceCombinations);
        return supportedSurfaceCombinations;
    }

    SurfaceConfig transformSurfaceConfig(int cameraMode, int imageFormat, Size size) {
        return SurfaceConfig.transformSurfaceConfig((int)cameraMode, (int)imageFormat, (Size)size, (SurfaceSizeDefinition)this.getUpdatedSurfaceSizeDefinitionByFormat(imageFormat));
    }

    static int getMaxFrameRate(CameraCharacteristicsCompat characteristics, int imageFormat, Size size) {
        int maxFramerate = 0;
        try {
            maxFramerate = (int)(1.0E9 / (double)((StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputMinFrameDuration(imageFormat, size));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxFramerate;
    }

    private static int getRangeLength(Range<Integer> range) {
        return (Integer)range.getUpper() - (Integer)range.getLower() + 1;
    }

    private static int getRangeDistance(Range<Integer> firstRange, Range<Integer> secondRange) {
        Preconditions.checkState((!firstRange.contains((Comparable)((Integer)secondRange.getUpper())) && !firstRange.contains((Comparable)((Integer)secondRange.getLower())) ? 1 : 0) != 0, (String)"Ranges must not intersect");
        if ((Integer)firstRange.getLower() > (Integer)secondRange.getUpper()) {
            return (Integer)firstRange.getLower() - (Integer)secondRange.getUpper();
        }
        return (Integer)secondRange.getLower() - (Integer)firstRange.getUpper();
    }

    private static Range<Integer> compareIntersectingRanges(Range<Integer> targetFps, Range<Integer> storedRange, Range<Integer> newRange) {
        double storedIntersectionsize = SupportedSurfaceCombination.getRangeLength((Range<Integer>)storedRange.intersect(targetFps));
        double newIntersectionSize = SupportedSurfaceCombination.getRangeLength((Range<Integer>)newRange.intersect(targetFps));
        double newRangeRatio = newIntersectionSize / (double)SupportedSurfaceCombination.getRangeLength(newRange);
        double storedRangeRatio = storedIntersectionsize / (double)SupportedSurfaceCombination.getRangeLength(storedRange);
        if (newIntersectionSize > storedIntersectionsize) {
            if (newRangeRatio >= 0.5 || newRangeRatio >= storedRangeRatio) {
                return newRange;
            }
        } else if (newIntersectionSize == storedIntersectionsize) {
            if (newRangeRatio > storedRangeRatio) {
                return newRange;
            }
            if (newRangeRatio == storedRangeRatio && (Integer)newRange.getLower() > (Integer)storedRange.getLower()) {
                return newRange;
            }
        } else if (storedRangeRatio < 0.5 && newRangeRatio > storedRangeRatio) {
            return newRange;
        }
        return storedRange;
    }

    @NonNull
    private Range<Integer> getClosestSupportedDeviceFrameRate(@Nullable Range<Integer> targetFrameRate, int maxFps) {
        if (targetFrameRate == null || targetFrameRate.equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
            return StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
        }
        Range[] availableFpsRanges = (Range[])this.mCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (availableFpsRanges == null) {
            return StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
        }
        targetFrameRate = new Range((Comparable)Integer.valueOf(Math.min((Integer)targetFrameRate.getLower(), maxFps)), (Comparable)Integer.valueOf(Math.min((Integer)targetFrameRate.getUpper(), maxFps)));
        Range bestRange = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
        int currentIntersectSize = 0;
        for (Range potentialRange : availableFpsRanges) {
            if (maxFps < (Integer)potentialRange.getLower()) continue;
            if (bestRange.equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                bestRange = potentialRange;
            }
            if (potentialRange.equals((Object)targetFrameRate)) {
                bestRange = potentialRange;
                break;
            }
            try {
                Range newIntersection = potentialRange.intersect(targetFrameRate);
                int newIntersectSize = SupportedSurfaceCombination.getRangeLength((Range<Integer>)newIntersection);
                if (currentIntersectSize == 0) {
                    bestRange = potentialRange;
                    currentIntersectSize = newIntersectSize;
                    continue;
                }
                if (newIntersectSize < currentIntersectSize) continue;
                bestRange = SupportedSurfaceCombination.compareIntersectingRanges((Range<Integer>)targetFrameRate, (Range<Integer>)bestRange, (Range<Integer>)potentialRange);
                currentIntersectSize = SupportedSurfaceCombination.getRangeLength((Range<Integer>)targetFrameRate.intersect(bestRange));
            }
            catch (IllegalArgumentException e) {
                if (currentIntersectSize != 0) continue;
                if (SupportedSurfaceCombination.getRangeDistance((Range<Integer>)potentialRange, (Range<Integer>)targetFrameRate) < SupportedSurfaceCombination.getRangeDistance((Range<Integer>)bestRange, (Range<Integer>)targetFrameRate)) {
                    bestRange = potentialRange;
                    continue;
                }
                if (SupportedSurfaceCombination.getRangeDistance((Range<Integer>)potentialRange, (Range<Integer>)targetFrameRate) != SupportedSurfaceCombination.getRangeDistance(bestRange, (Range<Integer>)targetFrameRate)) continue;
                if ((Integer)potentialRange.getLower() > (Integer)bestRange.getUpper()) {
                    bestRange = potentialRange;
                    continue;
                }
                if (SupportedSurfaceCombination.getRangeLength((Range<Integer>)potentialRange) >= SupportedSurfaceCombination.getRangeLength((Range<Integer>)bestRange)) continue;
                bestRange = potentialRange;
            }
        }
        return bestRange;
    }

    private Range<Integer> getUpdatedTargetFramerate(Range<Integer> newTargetFramerate, Range<Integer> storedTargetFramerate) {
        Range updatedTarget = storedTargetFramerate;
        if (storedTargetFramerate == null) {
            updatedTarget = newTargetFramerate;
        } else if (newTargetFramerate != null) {
            try {
                updatedTarget = storedTargetFramerate.intersect(newTargetFramerate);
            }
            catch (IllegalArgumentException e) {
                updatedTarget = storedTargetFramerate;
            }
        }
        return updatedTarget;
    }

    private int getUpdatedMaximumFps(int currentMaxFps, int imageFormat, Size size) {
        return Math.min(currentMaxFps, SupportedSurfaceCombination.getMaxFrameRate(this.mCharacteristics, imageFormat, size));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    Pair<Map<UseCaseConfig<?>, StreamSpec>, Map<AttachedSurfaceInfo, StreamSpec>> getSuggestedStreamSpecifications(int cameraMode, @NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap) {
        this.refreshPreviewSize();
        ArrayList newUseCaseConfigs = new ArrayList(newUseCaseConfigsSupportedSizeMap.keySet());
        List<Integer> useCasesPriorityOrder = this.getUseCasesPriorityOrder(newUseCaseConfigs);
        Map<UseCaseConfig<?>, DynamicRange> resolvedDynamicRanges = this.mDynamicRangeResolver.resolveAndValidateDynamicRanges(attachedSurfaces, newUseCaseConfigs, useCasesPriorityOrder);
        FeatureSettings featureSettings = this.createFeatureSettings(cameraMode, resolvedDynamicRanges);
        boolean isSurfaceCombinationSupported = this.isUseCasesCombinationSupported(featureSettings, attachedSurfaces, newUseCaseConfigsSupportedSizeMap);
        if (!isSurfaceCombinationSupported) {
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.mCameraId + ".  May be attempting to bind too many use cases. Existing surfaces: " + attachedSurfaces + " New configs: " + newUseCaseConfigs);
        }
        Range<Integer> targetFpsRange = this.getTargetFpsRange(attachedSurfaces, newUseCaseConfigs, useCasesPriorityOrder);
        Map<UseCaseConfig<?>, List<Size>> useCaseConfigToFilteredSupportedSizesMap = this.filterSupportedSizes(newUseCaseConfigsSupportedSizeMap, featureSettings, targetFpsRange);
        ArrayList<List<Size>> supportedOutputSizesList = new ArrayList<List<Size>>();
        for (Integer index : useCasesPriorityOrder) {
            UseCaseConfig useCaseConfig = (UseCaseConfig)newUseCaseConfigs.get(index);
            List<Size> supportedOutputSizes = useCaseConfigToFilteredSupportedSizesMap.get(useCaseConfig);
            supportedOutputSizes = this.applyResolutionSelectionOrderRelatedWorkarounds(supportedOutputSizes, useCaseConfig.getInputFormat());
            supportedOutputSizesList.add(supportedOutputSizes);
        }
        List<List<Size>> allPossibleSizeArrangements = this.getAllPossibleSizeArrangements(supportedOutputSizesList);
        HashMap<AttachedSurfaceInfo, StreamSpec> attachedSurfaceStreamSpecMap = new HashMap<AttachedSurfaceInfo, StreamSpec>();
        HashMap suggestedStreamSpecMap = new HashMap();
        HashMap<Integer, AttachedSurfaceInfo> surfaceConfigIndexAttachedSurfaceInfoMap = new HashMap<Integer, AttachedSurfaceInfo>();
        HashMap surfaceConfigIndexUseCaseConfigMap = new HashMap();
        List<Size> savedSizes = null;
        int savedConfigMaxFps = Integer.MAX_VALUE;
        List<Size> savedSizesForStreamUseCase = null;
        int savedConfigMaxFpsForStreamUseCase = Integer.MAX_VALUE;
        boolean containsZsl = StreamUseCaseUtil.containsZslUseCase(attachedSurfaces, newUseCaseConfigs);
        List<SurfaceConfig> orderedSurfaceConfigListForStreamUseCase = null;
        int maxSupportedFps = this.getMaxSupportedFpsFromAttachedSurfaces(attachedSurfaces);
        if (this.mIsStreamUseCaseSupported && !containsZsl) {
            for (List<Size> possibleSizeList : allPossibleSizeArrangements) {
                List surfaceConfigs = (List)this.getSurfaceConfigListAndFpsCeiling((int)cameraMode, attachedSurfaces, possibleSizeList, newUseCaseConfigs, useCasesPriorityOrder, (int)maxSupportedFps, surfaceConfigIndexAttachedSurfaceInfoMap, surfaceConfigIndexUseCaseConfigMap).first;
                orderedSurfaceConfigListForStreamUseCase = this.getOrderedSupportedStreamUseCaseSurfaceConfigList(featureSettings, surfaceConfigs);
                if (orderedSurfaceConfigListForStreamUseCase != null && !StreamUseCaseUtil.areCaptureTypesEligible(surfaceConfigIndexAttachedSurfaceInfoMap, surfaceConfigIndexUseCaseConfigMap, orderedSurfaceConfigListForStreamUseCase)) {
                    orderedSurfaceConfigListForStreamUseCase = null;
                }
                if (orderedSurfaceConfigListForStreamUseCase != null) {
                    if (StreamUseCaseUtil.areStreamUseCasesAvailableForSurfaceConfigs(this.mCharacteristics, orderedSurfaceConfigListForStreamUseCase)) break;
                    orderedSurfaceConfigListForStreamUseCase = null;
                }
                surfaceConfigIndexAttachedSurfaceInfoMap.clear();
                surfaceConfigIndexUseCaseConfigMap.clear();
            }
            if (orderedSurfaceConfigListForStreamUseCase == null && !isSurfaceCombinationSupported) {
                throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.mCameraId + ".  May be attempting to bind too many use cases. Existing surfaces: " + attachedSurfaces + " New configs: " + newUseCaseConfigs);
            }
        }
        boolean supportedSizesFound = false;
        boolean supportedSizesForStreamUseCaseFound = false;
        for (List<Size> list : allPossibleSizeArrangements) {
            Pair<List<SurfaceConfig>, Integer> pair = this.getSurfaceConfigListAndFpsCeiling(cameraMode, attachedSurfaces, list, newUseCaseConfigs, useCasesPriorityOrder, maxSupportedFps, null, null);
            List surfaceConfigList = (List)pair.first;
            int currentConfigFramerateCeiling = (Integer)pair.second;
            boolean isConfigFrameRateAcceptable = true;
            if (targetFpsRange != null && maxSupportedFps > currentConfigFramerateCeiling && currentConfigFramerateCeiling < (Integer)targetFpsRange.getLower()) {
                isConfigFrameRateAcceptable = false;
            }
            if (!supportedSizesFound && this.checkSupported(featureSettings, surfaceConfigList)) {
                if (savedConfigMaxFps == Integer.MAX_VALUE) {
                    savedConfigMaxFps = currentConfigFramerateCeiling;
                    savedSizes = list;
                } else if (savedConfigMaxFps < currentConfigFramerateCeiling) {
                    savedConfigMaxFps = currentConfigFramerateCeiling;
                    savedSizes = list;
                }
                if (isConfigFrameRateAcceptable) {
                    savedConfigMaxFps = currentConfigFramerateCeiling;
                    savedSizes = list;
                    supportedSizesFound = true;
                    if (supportedSizesForStreamUseCaseFound) break;
                }
            }
            if (orderedSurfaceConfigListForStreamUseCase == null || supportedSizesForStreamUseCaseFound || this.getOrderedSupportedStreamUseCaseSurfaceConfigList(featureSettings, surfaceConfigList) == null) continue;
            if (savedConfigMaxFpsForStreamUseCase == Integer.MAX_VALUE) {
                savedConfigMaxFpsForStreamUseCase = currentConfigFramerateCeiling;
                savedSizesForStreamUseCase = list;
            } else if (savedConfigMaxFpsForStreamUseCase < currentConfigFramerateCeiling) {
                savedConfigMaxFpsForStreamUseCase = currentConfigFramerateCeiling;
                savedSizesForStreamUseCase = list;
            }
            if (!isConfigFrameRateAcceptable) continue;
            savedConfigMaxFpsForStreamUseCase = currentConfigFramerateCeiling;
            savedSizesForStreamUseCase = list;
            supportedSizesForStreamUseCaseFound = true;
            if (!supportedSizesFound) continue;
            break;
        }
        if (savedSizes != null) {
            Range<Integer> targetFramerateForDevice = null;
            if (targetFpsRange != null) {
                targetFramerateForDevice = this.getClosestSupportedDeviceFrameRate(targetFpsRange, savedConfigMaxFps);
            }
            for (UseCaseConfig useCaseConfig : newUseCaseConfigs) {
                Size resolutionForUseCase = (Size)savedSizes.get(useCasesPriorityOrder.indexOf(newUseCaseConfigs.indexOf(useCaseConfig)));
                StreamSpec.Builder streamSpecBuilder = StreamSpec.builder((Size)resolutionForUseCase).setDynamicRange((DynamicRange)Preconditions.checkNotNull((Object)resolvedDynamicRanges.get(useCaseConfig))).setImplementationOptions((Config)StreamUseCaseUtil.getStreamSpecImplementationOptions(useCaseConfig));
                if (targetFramerateForDevice != null) {
                    streamSpecBuilder.setExpectedFrameRateRange(targetFramerateForDevice);
                }
                suggestedStreamSpecMap.put(useCaseConfig, streamSpecBuilder.build());
            }
        } else {
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.mCameraId + " and Hardware level: " + this.mHardwareLevel + ". May be the specified resolution is too large and not supported. Existing surfaces: " + attachedSurfaces + " New configs: " + newUseCaseConfigs);
        }
        if (orderedSurfaceConfigListForStreamUseCase != null && savedConfigMaxFps == savedConfigMaxFpsForStreamUseCase && savedSizes.size() == savedSizesForStreamUseCase.size()) {
            boolean bl;
            void var27_33;
            boolean hasDifferenceSavedSizes = false;
            boolean bl2 = false;
            while (var27_33 < savedSizes.size()) {
                if (!((Size)savedSizes.get((int)var27_33)).equals(savedSizesForStreamUseCase.get((int)var27_33))) {
                    hasDifferenceSavedSizes = true;
                    break;
                }
                ++var27_33;
            }
            if (!hasDifferenceSavedSizes && !(bl = StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithInteropOverride(this.mCharacteristics, attachedSurfaces, suggestedStreamSpecMap, attachedSurfaceStreamSpecMap))) {
                StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithSupportedSurfaceConfigs(suggestedStreamSpecMap, attachedSurfaceStreamSpecMap, surfaceConfigIndexAttachedSurfaceInfoMap, surfaceConfigIndexUseCaseConfigMap, orderedSurfaceConfigListForStreamUseCase);
            }
        }
        return new Pair(suggestedStreamSpecMap, attachedSurfaceStreamSpecMap);
    }

    @NonNull
    private FeatureSettings createFeatureSettings(int cameraMode, @NonNull Map<UseCaseConfig<?>, DynamicRange> resolvedDynamicRanges) {
        int requiredMaxBitDepth = SupportedSurfaceCombination.getRequiredMaxBitDepth(resolvedDynamicRanges);
        if (cameraMode != 0 && requiredMaxBitDepth == 10) {
            throw new IllegalArgumentException(String.format("Camera device id is %s. 10 bit dynamic range is not currently supported in %s camera mode.", this.mCameraId, CameraMode.toLabelString((int)cameraMode)));
        }
        return FeatureSettings.of(cameraMode, requiredMaxBitDepth);
    }

    private boolean isUseCasesCombinationSupported(@NonNull FeatureSettings featureSettings, @NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap) {
        ArrayList<SurfaceConfig> surfaceConfigs = new ArrayList<SurfaceConfig>();
        for (AttachedSurfaceInfo attachedSurface : attachedSurfaces) {
            surfaceConfigs.add(attachedSurface.getSurfaceConfig());
        }
        CompareSizesByArea compareSizesByArea = new CompareSizesByArea();
        for (UseCaseConfig<?> useCaseConfig : newUseCaseConfigsSupportedSizeMap.keySet()) {
            List<Size> supportedSizes = newUseCaseConfigsSupportedSizeMap.get(useCaseConfig);
            Preconditions.checkArgument((supportedSizes != null && !supportedSizes.isEmpty() ? 1 : 0) != 0, (Object)("No available output size is found for " + useCaseConfig + "."));
            Size minSize = Collections.min(supportedSizes, compareSizesByArea);
            int imageFormat = useCaseConfig.getInputFormat();
            surfaceConfigs.add(SurfaceConfig.transformSurfaceConfig((int)featureSettings.getCameraMode(), (int)imageFormat, (Size)minSize, (SurfaceSizeDefinition)this.getUpdatedSurfaceSizeDefinitionByFormat(imageFormat)));
        }
        return this.checkSupported(featureSettings, surfaceConfigs);
    }

    @Nullable
    private Range<Integer> getTargetFpsRange(@NonNull List<AttachedSurfaceInfo> attachedSurfaces, @NonNull List<UseCaseConfig<?>> newUseCaseConfigs, @NonNull List<Integer> useCasesPriorityOrder) {
        Range<Integer> targetFramerateForConfig = null;
        for (AttachedSurfaceInfo attachedSurfaceInfo : attachedSurfaces) {
            targetFramerateForConfig = this.getUpdatedTargetFramerate((Range<Integer>)attachedSurfaceInfo.getTargetFrameRate(), targetFramerateForConfig);
        }
        for (Integer index : useCasesPriorityOrder) {
            targetFramerateForConfig = this.getUpdatedTargetFramerate((Range<Integer>)newUseCaseConfigs.get(index).getTargetFrameRate(null), targetFramerateForConfig);
        }
        return targetFramerateForConfig;
    }

    private int getMaxSupportedFpsFromAttachedSurfaces(@NonNull List<AttachedSurfaceInfo> attachedSurfaces) {
        int existingSurfaceFrameRateCeiling = Integer.MAX_VALUE;
        for (AttachedSurfaceInfo attachedSurfaceInfo : attachedSurfaces) {
            existingSurfaceFrameRateCeiling = this.getUpdatedMaximumFps(existingSurfaceFrameRateCeiling, attachedSurfaceInfo.getImageFormat(), attachedSurfaceInfo.getSize());
        }
        return existingSurfaceFrameRateCeiling;
    }

    @NonNull
    private Map<UseCaseConfig<?>, List<Size>> filterSupportedSizes(@NonNull Map<UseCaseConfig<?>, List<Size>> newUseCaseConfigsSupportedSizeMap, @NonNull FeatureSettings featureSettings, @Nullable Range<Integer> targetFpsRange) {
        HashMap filteredUseCaseConfigToSupportedSizesMap = new HashMap();
        for (UseCaseConfig<?> useCaseConfig : newUseCaseConfigsSupportedSizeMap.keySet()) {
            ArrayList<Size> reducedSizeList = new ArrayList<Size>();
            HashMap configSizeUniqueMaxFpsMap = new HashMap();
            for (Size size : newUseCaseConfigsSupportedSizeMap.get(useCaseConfig)) {
                HashSet<Integer> uniqueMaxFrameRates;
                int imageFormat = useCaseConfig.getInputFormat();
                SurfaceConfig.ConfigSize configSize = SurfaceConfig.transformSurfaceConfig((int)featureSettings.getCameraMode(), (int)imageFormat, (Size)size, (SurfaceSizeDefinition)this.getUpdatedSurfaceSizeDefinitionByFormat(imageFormat)).getConfigSize();
                int maxFrameRate = Integer.MAX_VALUE;
                if (targetFpsRange != null) {
                    maxFrameRate = SupportedSurfaceCombination.getMaxFrameRate(this.mCharacteristics, imageFormat, size);
                }
                if ((uniqueMaxFrameRates = (HashSet<Integer>)configSizeUniqueMaxFpsMap.get(configSize)) == null) {
                    uniqueMaxFrameRates = new HashSet<Integer>();
                    configSizeUniqueMaxFpsMap.put(configSize, uniqueMaxFrameRates);
                }
                if (uniqueMaxFrameRates.contains(maxFrameRate)) continue;
                reducedSizeList.add(size);
                uniqueMaxFrameRates.add(maxFrameRate);
            }
            filteredUseCaseConfigToSupportedSizesMap.put(useCaseConfig, reducedSizeList);
        }
        return filteredUseCaseConfigToSupportedSizesMap;
    }

    private Pair<List<SurfaceConfig>, Integer> getSurfaceConfigListAndFpsCeiling(int cameraMode, List<AttachedSurfaceInfo> attachedSurfaces, List<Size> possibleSizeList, List<UseCaseConfig<?>> newUseCaseConfigs, List<Integer> useCasesPriorityOrder, int currentConfigFramerateCeiling, @Nullable Map<Integer, AttachedSurfaceInfo> surfaceConfigIndexAttachedSurfaceInfoMap, @Nullable Map<Integer, UseCaseConfig<?>> surfaceConfigIndexUseCaseConfigMap) {
        ArrayList<SurfaceConfig> surfaceConfigList = new ArrayList<SurfaceConfig>();
        for (AttachedSurfaceInfo attachedSurfaceInfo : attachedSurfaces) {
            surfaceConfigList.add(attachedSurfaceInfo.getSurfaceConfig());
            if (surfaceConfigIndexAttachedSurfaceInfoMap == null) continue;
            surfaceConfigIndexAttachedSurfaceInfoMap.put(surfaceConfigList.size() - 1, attachedSurfaceInfo);
        }
        for (int i = 0; i < possibleSizeList.size(); ++i) {
            Size size = possibleSizeList.get(i);
            UseCaseConfig<?> newUseCase = newUseCaseConfigs.get(useCasesPriorityOrder.get(i));
            int imageFormat = newUseCase.getInputFormat();
            SurfaceConfig surfaceConfig = SurfaceConfig.transformSurfaceConfig((int)cameraMode, (int)imageFormat, (Size)size, (SurfaceSizeDefinition)this.getUpdatedSurfaceSizeDefinitionByFormat(imageFormat));
            surfaceConfigList.add(surfaceConfig);
            if (surfaceConfigIndexUseCaseConfigMap != null) {
                surfaceConfigIndexUseCaseConfigMap.put(surfaceConfigList.size() - 1, newUseCase);
            }
            currentConfigFramerateCeiling = this.getUpdatedMaximumFps(currentConfigFramerateCeiling, newUseCase.getInputFormat(), size);
        }
        return new Pair(surfaceConfigList, (Object)currentConfigFramerateCeiling);
    }

    @VisibleForTesting
    @NonNull
    List<Size> applyResolutionSelectionOrderRelatedWorkarounds(@NonNull List<Size> sizeList, int imageFormat) {
        List<Size> resultList;
        int targetAspectRatio = this.mTargetAspectRatio.get(this.mCameraId, this.mCharacteristics);
        Rational ratio = null;
        switch (targetAspectRatio) {
            case 0: {
                ratio = AspectRatioUtil.ASPECT_RATIO_4_3;
                break;
            }
            case 1: {
                ratio = AspectRatioUtil.ASPECT_RATIO_16_9;
                break;
            }
            case 2: {
                Size maxJpegSize = this.getUpdatedSurfaceSizeDefinitionByFormat(256).getMaximumSize(256);
                ratio = new Rational(maxJpegSize.getWidth(), maxJpegSize.getHeight());
                break;
            }
            case 3: {
                ratio = null;
            }
        }
        if (ratio == null) {
            resultList = sizeList;
        } else {
            ArrayList<Size> aspectRatioMatchedSizeList = new ArrayList<Size>();
            resultList = new ArrayList<Size>();
            for (Size size : sizeList) {
                if (AspectRatioUtil.hasMatchingAspectRatio((Size)size, (Rational)ratio)) {
                    aspectRatioMatchedSizeList.add(size);
                    continue;
                }
                resultList.add(size);
            }
            resultList.addAll(0, aspectRatioMatchedSizeList);
        }
        return this.mResolutionCorrector.insertOrPrioritize(SurfaceConfig.getConfigType((int)imageFormat), resultList);
    }

    private static int getRequiredMaxBitDepth(@NonNull Map<UseCaseConfig<?>, DynamicRange> resolvedDynamicRanges) {
        for (DynamicRange dynamicRange : resolvedDynamicRanges.values()) {
            if (dynamicRange.getBitDepth() != 10) continue;
            return 10;
        }
        return 8;
    }

    private List<Integer> getUseCasesPriorityOrder(List<UseCaseConfig<?>> newUseCaseConfigs) {
        ArrayList<Integer> priorityOrder = new ArrayList<Integer>();
        ArrayList<Integer> priorityValueList = new ArrayList<Integer>();
        for (UseCaseConfig<?> config : newUseCaseConfigs) {
            int priority = config.getSurfaceOccupancyPriority(0);
            if (priorityValueList.contains(priority)) continue;
            priorityValueList.add(priority);
        }
        Collections.sort(priorityValueList);
        Collections.reverse(priorityValueList);
        Iterator<Object> iterator = priorityValueList.iterator();
        while (iterator.hasNext()) {
            int priorityValue = (Integer)iterator.next();
            for (UseCaseConfig<?> config : newUseCaseConfigs) {
                if (priorityValue != config.getSurfaceOccupancyPriority(0)) continue;
                priorityOrder.add(newUseCaseConfigs.indexOf(config));
            }
        }
        return priorityOrder;
    }

    private List<List<Size>> getAllPossibleSizeArrangements(List<List<Size>> supportedOutputSizesList) {
        int totalArrangementsCount = 1;
        for (List<Size> supportedOutputSizes : supportedOutputSizesList) {
            totalArrangementsCount *= supportedOutputSizes.size();
        }
        if (totalArrangementsCount == 0) {
            throw new IllegalArgumentException("Failed to find supported resolutions.");
        }
        ArrayList<List<Size>> allPossibleSizeArrangements = new ArrayList<List<Size>>();
        for (int i = 0; i < totalArrangementsCount; ++i) {
            ArrayList sizeList = new ArrayList();
            allPossibleSizeArrangements.add(sizeList);
        }
        int currentRunCount = totalArrangementsCount;
        int nextRunCount = currentRunCount / supportedOutputSizesList.get(0).size();
        for (int currentIndex = 0; currentIndex < supportedOutputSizesList.size(); ++currentIndex) {
            List<Size> supportedOutputSizes = supportedOutputSizesList.get(currentIndex);
            for (int i = 0; i < totalArrangementsCount; ++i) {
                List surfaceConfigList = (List)allPossibleSizeArrangements.get(i);
                surfaceConfigList.add(supportedOutputSizes.get(i % currentRunCount / nextRunCount));
            }
            if (currentIndex >= supportedOutputSizesList.size() - 1) continue;
            currentRunCount = nextRunCount;
            nextRunCount = currentRunCount / supportedOutputSizesList.get(currentIndex + 1).size();
        }
        return allPossibleSizeArrangements;
    }

    private Size getMaxOutputSizeByFormat(StreamConfigurationMap map, int imageFormat, boolean highResolutionIncluded) {
        Size[] highResolutionOutputSizes;
        Size[] outputSizes = imageFormat == 34 ? map.getOutputSizes(SurfaceTexture.class) : map.getOutputSizes(imageFormat);
        if (outputSizes == null || outputSizes.length == 0) {
            return null;
        }
        CompareSizesByArea compareSizesByArea = new CompareSizesByArea();
        Size maxSize = Collections.max(Arrays.asList(outputSizes), compareSizesByArea);
        Size maxHighResolutionSize = SizeUtil.RESOLUTION_ZERO;
        if (Build.VERSION.SDK_INT >= 23 && highResolutionIncluded && (highResolutionOutputSizes = Api23Impl.getHighResolutionOutputSizes(map, imageFormat)) != null && highResolutionOutputSizes.length > 0) {
            maxHighResolutionSize = Collections.max(Arrays.asList(highResolutionOutputSizes), compareSizesByArea);
        }
        return Collections.max(Arrays.asList(maxSize, maxHighResolutionSize), compareSizesByArea);
    }

    private void generateSupportedCombinationList() {
        this.mSurfaceCombinations.addAll(GuaranteedConfigurationsUtil.generateSupportedCombinationList(this.mHardwareLevel, this.mIsRawSupported, this.mIsBurstCaptureSupported));
        this.mSurfaceCombinations.addAll(this.mExtraSupportedSurfaceCombinationsContainer.get(this.mCameraId, this.mHardwareLevel));
    }

    private void generateUltraHighSupportedCombinationList() {
        this.mUltraHighSurfaceCombinations.addAll(GuaranteedConfigurationsUtil.getUltraHighResolutionSupportedCombinationList());
    }

    private void generateConcurrentSupportedCombinationList() {
        this.mConcurrentSurfaceCombinations.addAll(GuaranteedConfigurationsUtil.getConcurrentSupportedCombinationList());
    }

    private void generate10BitSupportedCombinationList() {
        this.mSurfaceCombinations10Bit.addAll(GuaranteedConfigurationsUtil.get10BitSupportedCombinationList());
    }

    private void generateStreamUseCaseSupportedCombinationList() {
        if (Build.VERSION.SDK_INT >= 33) {
            this.mSurfaceCombinationsStreamUseCase.addAll(GuaranteedConfigurationsUtil.getStreamUseCaseSupportedCombinationList());
        }
    }

    private void checkCustomization() {
    }

    private void generateSurfaceSizeDefinition() {
        Size previewSize = this.mDisplayInfoManager.getPreviewSize();
        Size recordSize = this.getRecordSize();
        this.mSurfaceSizeDefinition = SurfaceSizeDefinition.create((Size)SizeUtil.RESOLUTION_VGA, new HashMap(), (Size)previewSize, new HashMap(), (Size)recordSize, new HashMap(), new HashMap());
    }

    @VisibleForTesting
    @NonNull
    SurfaceSizeDefinition getUpdatedSurfaceSizeDefinitionByFormat(int format) {
        if (!this.mSurfaceSizeDefinitionFormats.contains(format)) {
            this.updateS720pOrS1440pSizeByFormat(this.mSurfaceSizeDefinition.getS720pSizeMap(), SizeUtil.RESOLUTION_720P, format);
            this.updateS720pOrS1440pSizeByFormat(this.mSurfaceSizeDefinition.getS1440pSizeMap(), SizeUtil.RESOLUTION_1440P, format);
            this.updateMaximumSizeByFormat(this.mSurfaceSizeDefinition.getMaximumSizeMap(), format);
            this.updateUltraMaximumSizeByFormat(this.mSurfaceSizeDefinition.getUltraMaximumSizeMap(), format);
            this.mSurfaceSizeDefinitionFormats.add(format);
        }
        return this.mSurfaceSizeDefinition;
    }

    private void updateS720pOrS1440pSizeByFormat(@NonNull Map<Integer, Size> sizeMap, @NonNull Size targetSize, int format) {
        if (!this.mIsConcurrentCameraModeSupported) {
            return;
        }
        StreamConfigurationMap originalMap = this.mCharacteristics.getStreamConfigurationMapCompat().toStreamConfigurationMap();
        Size maxOutputSize = this.getMaxOutputSizeByFormat(originalMap, format, false);
        sizeMap.put(format, maxOutputSize == null ? targetSize : Collections.min(Arrays.asList(targetSize, maxOutputSize), new CompareSizesByArea()));
    }

    private void updateMaximumSizeByFormat(@NonNull Map<Integer, Size> sizeMap, int format) {
        StreamConfigurationMap originalMap = this.mCharacteristics.getStreamConfigurationMapCompat().toStreamConfigurationMap();
        Size maxOutputSize = this.getMaxOutputSizeByFormat(originalMap, format, true);
        if (maxOutputSize != null) {
            sizeMap.put(format, maxOutputSize);
        }
    }

    private void updateUltraMaximumSizeByFormat(@NonNull Map<Integer, Size> sizeMap, int format) {
        if (Build.VERSION.SDK_INT < 31 || !this.mIsUltraHighResolutionSensorSupported) {
            return;
        }
        StreamConfigurationMap maximumResolutionMap = (StreamConfigurationMap)this.mCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP_MAXIMUM_RESOLUTION);
        if (maximumResolutionMap == null) {
            return;
        }
        sizeMap.put(format, this.getMaxOutputSizeByFormat(maximumResolutionMap, format, true));
    }

    private void refreshPreviewSize() {
        this.mDisplayInfoManager.refresh();
        if (this.mSurfaceSizeDefinition == null) {
            this.generateSurfaceSizeDefinition();
        } else {
            Size previewSize = this.mDisplayInfoManager.getPreviewSize();
            this.mSurfaceSizeDefinition = SurfaceSizeDefinition.create((Size)this.mSurfaceSizeDefinition.getAnalysisSize(), (Map)this.mSurfaceSizeDefinition.getS720pSizeMap(), (Size)previewSize, (Map)this.mSurfaceSizeDefinition.getS1440pSizeMap(), (Size)this.mSurfaceSizeDefinition.getRecordSize(), (Map)this.mSurfaceSizeDefinition.getMaximumSizeMap(), (Map)this.mSurfaceSizeDefinition.getUltraMaximumSizeMap());
        }
    }

    @NonNull
    private Size getRecordSize() {
        int cameraId;
        try {
            cameraId = Integer.parseInt(this.mCameraId);
        }
        catch (NumberFormatException e) {
            return this.getRecordSizeFromStreamConfigurationMap();
        }
        CamcorderProfile profile = null;
        if (this.mCamcorderProfileHelper.hasProfile(cameraId, 1)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 1);
        }
        if (profile != null) {
            return new Size(profile.videoFrameWidth, profile.videoFrameHeight);
        }
        return this.getRecordSizeByHasProfile(cameraId);
    }

    @NonNull
    private Size getRecordSizeFromStreamConfigurationMap() {
        StreamConfigurationMapCompat mapCompat = this.mCharacteristics.getStreamConfigurationMapCompat();
        Size[] videoSizeArr = mapCompat.toStreamConfigurationMap().getOutputSizes(MediaRecorder.class);
        if (videoSizeArr == null) {
            return SizeUtil.RESOLUTION_480P;
        }
        Arrays.sort(videoSizeArr, new CompareSizesByArea(true));
        for (Size size : videoSizeArr) {
            if (size.getWidth() > SizeUtil.RESOLUTION_1080P.getWidth() || size.getHeight() > SizeUtil.RESOLUTION_1080P.getHeight()) continue;
            return size;
        }
        return SizeUtil.RESOLUTION_480P;
    }

    @NonNull
    private Size getRecordSizeByHasProfile(int cameraId) {
        Size recordSize = SizeUtil.RESOLUTION_480P;
        CamcorderProfile profile = null;
        if (this.mCamcorderProfileHelper.hasProfile(cameraId, 10)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 10);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 8)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 8);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 12)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 12);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 6)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 6);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 5)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 5);
        } else if (this.mCamcorderProfileHelper.hasProfile(cameraId, 4)) {
            profile = this.mCamcorderProfileHelper.get(cameraId, 4);
        }
        if (profile != null) {
            recordSize = new Size(profile.videoFrameWidth, profile.videoFrameHeight);
        }
        return recordSize;
    }

    @AutoValue
    static abstract class FeatureSettings {
        FeatureSettings() {
        }

        @NonNull
        static FeatureSettings of(int cameraMode, int requiredMaxBitDepth) {
            return new AutoValue_SupportedSurfaceCombination_FeatureSettings(cameraMode, requiredMaxBitDepth);
        }

        abstract int getCameraMode();

        abstract int getRequiredMaxBitDepth();
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static Size[] getHighResolutionOutputSizes(StreamConfigurationMap streamConfigurationMap, int format) {
            return streamConfigurationMap.getHighResolutionOutputSizes(format);
        }
    }
}

