/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.FlashAvailabilityBufferUnderflowQuirk;
import androidx.camera.camera2.internal.compat.workaround.CameraCharacteristicsProvider;
import androidx.camera.core.Logger;
import java.nio.BufferUnderflowException;

@RequiresApi(value=21)
public final class FlashAvailabilityChecker {
    private static final String TAG = "FlashAvailability";

    public static boolean isFlashAvailable(@NonNull CameraCharacteristicsProvider provider) {
        return FlashAvailabilityChecker.isFlashAvailable(false, provider);
    }

    public static boolean isFlashAvailable(boolean allowRethrowOnError, @NonNull CameraCharacteristicsProvider provider) {
        Boolean flashAvailable;
        try {
            flashAvailable = (Boolean)provider.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        }
        catch (BufferUnderflowException e) {
            if (DeviceQuirks.get(FlashAvailabilityBufferUnderflowQuirk.class) != null) {
                Logger.d((String)TAG, (String)String.format("Device is known to throw an exception while checking flash availability. Flash is not available. [Manufacturer: %s, Model: %s, API Level: %d].", Build.MANUFACTURER, Build.MODEL, Build.VERSION.SDK_INT));
            } else {
                Logger.e((String)TAG, (String)String.format("Exception thrown while checking for flash availability on device not known to throw exceptions during this check. Please file an issue at https://issuetracker.google.com/issues/new?component=618491&template=1257717 with this error message [Manufacturer: %s, Model: %s, API Level: %d].\nFlash is not available.", Build.MANUFACTURER, Build.MODEL, Build.VERSION.SDK_INT), (Throwable)e);
            }
            if (allowRethrowOnError) {
                throw e;
            }
            flashAvailable = false;
        }
        if (flashAvailable == null) {
            Logger.w((String)TAG, (String)"Characteristics did not contain key FLASH_INFO_AVAILABLE. Flash is not available.");
        }
        return flashAvailable != null ? flashAvailable : false;
    }

    private FlashAvailabilityChecker() {
    }
}

