/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.quirk.AutoFlashUnderExposedQuirk;
import androidx.camera.core.impl.Quirks;

@RequiresApi(value=21)
public class OverrideAeModeForStillCapture {
    private final boolean mHasAutoFlashUnderExposedQuirk;
    private boolean mAePrecaptureStarted = false;

    public OverrideAeModeForStillCapture(@NonNull Quirks cameraQuirks) {
        this.mHasAutoFlashUnderExposedQuirk = cameraQuirks.get(AutoFlashUnderExposedQuirk.class) != null;
    }

    public void onAePrecaptureStarted() {
        this.mAePrecaptureStarted = true;
    }

    public void onAePrecaptureFinished() {
        this.mAePrecaptureStarted = false;
    }

    public boolean shouldSetAeModeAlwaysFlash(int flashMode) {
        return this.mAePrecaptureStarted && flashMode == 0 && this.mHasAutoFlashUnderExposedQuirk;
    }
}

