/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.TorchIsClosedAfterImageCapturingQuirk;
import androidx.camera.camera2.interop.ExperimentalCamera2Interop;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import java.util.List;

@RequiresApi(value=21)
public class TorchStateReset {
    private final boolean mIsImageCaptureTorchIsClosedQuirkEnabled = DeviceQuirks.get(TorchIsClosedAfterImageCapturingQuirk.class) != null;

    public boolean isTorchResetRequired(@NonNull List<CaptureRequest> captureRequestList, boolean isSingleCapture) {
        if (this.mIsImageCaptureTorchIsClosedQuirkEnabled && isSingleCapture) {
            for (CaptureRequest captureRequest : captureRequestList) {
                Integer flashMode = (Integer)captureRequest.get(CaptureRequest.FLASH_MODE);
                if (flashMode == null || flashMode != 2) continue;
                return true;
            }
        }
        return false;
    }

    @OptIn(markerClass={ExperimentalCamera2Interop.class})
    @NonNull
    public CaptureConfig createTorchResetRequest(@NonNull CaptureConfig repeatingConfig) {
        CaptureConfig.Builder captureConfigBuilder = new CaptureConfig.Builder();
        captureConfigBuilder.setTemplateType(repeatingConfig.getTemplateType());
        for (DeferrableSurface deferrableSurface : repeatingConfig.getSurfaces()) {
            captureConfigBuilder.addSurface(deferrableSurface);
        }
        captureConfigBuilder.addImplementationOptions(repeatingConfig.getImplementationOptions());
        Camera2ImplConfig.Builder builder = new Camera2ImplConfig.Builder();
        builder.setCaptureRequestOption(CaptureRequest.FLASH_MODE, 0);
        captureConfigBuilder.addImplementationOptions((Config)builder.build());
        return captureConfigBuilder.build();
    }
}

