/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class CameraOrientationUtil {
    private static final String TAG = "CameraOrientationUtil";
    private static final boolean DEBUG = false;

    private CameraOrientationUtil() {
    }

    public static int getRelativeImageRotation(int destRotationDegrees, int sourceRotationDegrees, boolean isOppositeFacing) {
        int result = isOppositeFacing ? (sourceRotationDegrees - destRotationDegrees + 360) % 360 : (sourceRotationDegrees + destRotationDegrees) % 360;
        return result;
    }

    public static int surfaceRotationToDegrees(int rotationEnum) {
        int rotationDegrees;
        switch (rotationEnum) {
            case 0: {
                rotationDegrees = 0;
                break;
            }
            case 1: {
                rotationDegrees = 90;
                break;
            }
            case 2: {
                rotationDegrees = 180;
                break;
            }
            case 3: {
                rotationDegrees = 270;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported surface rotation: " + rotationEnum);
            }
        }
        return rotationDegrees;
    }
}

