/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.CameraDeviceSurfaceManager;
import androidx.camera.core.CameraFactory;
import androidx.camera.core.CameraX;
import androidx.camera.core.Config;
import androidx.camera.core.MutableConfig;
import androidx.camera.core.MutableOptionsBundle;
import androidx.camera.core.OptionsBundle;
import androidx.camera.core.TargetConfig;
import androidx.camera.core.UseCaseConfigFactory;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;

public final class CameraXConfig
implements TargetConfig<CameraX>,
Config {
    static final Config.Option<CameraFactory> OPTION_CAMERA_FACTORY = Config.Option.create("camerax.core.appConfig.cameraFactory", CameraFactory.class);
    static final Config.Option<CameraDeviceSurfaceManager> OPTION_DEVICE_SURFACE_MANAGER = Config.Option.create("camerax.core.appConfig.deviceSurfaceManager", CameraDeviceSurfaceManager.class);
    static final Config.Option<UseCaseConfigFactory> OPTION_USECASE_CONFIG_FACTORY = Config.Option.create("camerax.core.appConfig.useCaseConfigFactory", UseCaseConfigFactory.class);
    static final Config.Option<Executor> OPTION_CAMERA_EXECUTOR = Config.Option.create("camerax.core.appConfig.cameraExecutor", Executor.class);
    private final OptionsBundle mConfig;

    CameraXConfig(OptionsBundle options) {
        this.mConfig = options;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraFactory getCameraFactory(@Nullable CameraFactory valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_CAMERA_FACTORY, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public CameraDeviceSurfaceManager getDeviceSurfaceManager(@Nullable CameraDeviceSurfaceManager valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_DEVICE_SURFACE_MANAGER, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public UseCaseConfigFactory getUseCaseConfigRepository(@Nullable UseCaseConfigFactory valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_USECASE_CONFIG_FACTORY, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Executor getCameraExecutor(@Nullable Executor valueIfMissing) {
        return this.mConfig.retrieveOption(OPTION_CAMERA_EXECUTOR, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean containsOption(@NonNull Config.Option<?> id) {
        return this.mConfig.containsOption(id);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id) {
        return this.mConfig.retrieveOption(id);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Config.Option<ValueT> id, @Nullable ValueT valueIfMissing) {
        return this.mConfig.retrieveOption(id, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void findOptions(@NonNull String idStem, @NonNull Config.OptionMatcher matcher) {
        this.mConfig.findOptions(idStem, matcher);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Set<Config.Option<?>> listOptions() {
        return this.mConfig.listOptions();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Class<CameraX> getTargetClass(@Nullable Class<CameraX> valueIfMissing) {
        Class<CameraX> storedClass = this.retrieveOption(OPTION_TARGET_CLASS, valueIfMissing);
        return storedClass;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Class<CameraX> getTargetClass() {
        Class storedClass = (Class)this.retrieveOption(OPTION_TARGET_CLASS);
        return storedClass;
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public String getTargetName(@Nullable String valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_NAME, valueIfMissing);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public String getTargetName() {
        return (String)this.retrieveOption(OPTION_TARGET_NAME);
    }

    public static final class Builder
    implements TargetConfig.Builder<CameraX, Builder> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder() {
            this(MutableOptionsBundle.create());
        }

        private Builder(MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            Class oldConfigClass = mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(CameraX.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setTargetClass((Class)CameraX.class);
        }

        @NonNull
        public static Builder fromConfig(@NonNull CameraXConfig configuration) {
            return new Builder(MutableOptionsBundle.from(configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setCameraFactory(@NonNull CameraFactory cameraFactory) {
            this.getMutableConfig().insertOption(OPTION_CAMERA_FACTORY, cameraFactory);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setDeviceSurfaceManager(@NonNull CameraDeviceSurfaceManager repository) {
            this.getMutableConfig().insertOption(OPTION_DEVICE_SURFACE_MANAGER, repository);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setUseCaseConfigFactory(@NonNull UseCaseConfigFactory repository) {
            this.getMutableConfig().insertOption(OPTION_USECASE_CONFIG_FACTORY, repository);
            return this;
        }

        @NonNull
        public Builder setCameraExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(OPTION_CAMERA_EXECUTOR, executor);
            return this;
        }

        @NonNull
        private MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @NonNull
        public CameraXConfig build() {
            return new CameraXConfig(OptionsBundle.from(this.mMutableConfig));
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetClass(@NonNull Class<CameraX> targetClass) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(TargetConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @Override
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Builder setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_NAME, targetName);
            return this;
        }
    }

    public static interface Provider {
        @NonNull
        public CameraXConfig getCameraXConfig();
    }
}

