/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.DeferrableSurface;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DeferrableSurfaces {
    private static final String TAG = "DeferrableSurfaces";

    private DeferrableSurfaces() {
    }

    @NonNull
    public static List<Surface> surfaceList(@NonNull Collection<DeferrableSurface> deferrableSurfaces) {
        return DeferrableSurfaces.surfaceList(deferrableSurfaces, true);
    }

    @NonNull
    public static List<Surface> surfaceList(@NonNull Collection<DeferrableSurface> deferrableSurfaces, boolean removeNullSurfaces) {
        ArrayList<ListenableFuture<Surface>> listenableFutureSurfaces = new ArrayList<ListenableFuture<Surface>>();
        for (DeferrableSurface deferrableSurface : deferrableSurfaces) {
            listenableFutureSurfaces.add(deferrableSurface.getSurface());
        }
        try {
            ArrayList surfaces = new ArrayList((Collection)Futures.successfulAsList(listenableFutureSurfaces).get());
            if (removeNullSurfaces) {
                surfaces.removeAll(Collections.singleton(null));
            }
            return Collections.unmodifiableList(surfaces);
        }
        catch (InterruptedException | ExecutionException e) {
            return Collections.unmodifiableList(Collections.emptyList());
        }
    }

    @NonNull
    public static Set<Surface> surfaceSet(@NonNull Collection<DeferrableSurface> deferrableSurfaces) {
        ArrayList<ListenableFuture<Surface>> listenableFutureSurfaces = new ArrayList<ListenableFuture<Surface>>();
        for (DeferrableSurface deferrableSurface : deferrableSurfaces) {
            listenableFutureSurfaces.add(deferrableSurface.getSurface());
        }
        try {
            HashSet surfaces = new HashSet((Collection)Futures.successfulAsList(listenableFutureSurfaces).get());
            surfaces.removeAll(Collections.singleton(null));
            return Collections.unmodifiableSet(surfaces);
        }
        catch (InterruptedException | ExecutionException e) {
            return Collections.unmodifiableSet(Collections.emptySet());
        }
    }
}

