/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.location.Location;
import androidx.annotation.Nullable;
import androidx.camera.core.Exif;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

final class ImageSaver
implements Runnable {
    private static final String TAG = "ImageSaver";
    @Nullable
    private final Location mLocation;
    private final ImageProxy mImage;
    private final int mOrientation;
    private final boolean mIsReversedHorizontal;
    private final boolean mIsReversedVertical;
    final File mFile;
    private final Executor mExecutor;
    final OnImageSavedCallback mCallback;

    ImageSaver(ImageProxy image, File file, int orientation, boolean reversedHorizontal, boolean reversedVertical, @Nullable Location location, Executor executor, OnImageSavedCallback callback) {
        this.mImage = image;
        this.mFile = file;
        this.mOrientation = orientation;
        this.mIsReversedHorizontal = reversedHorizontal;
        this.mIsReversedVertical = reversedVertical;
        this.mCallback = callback;
        this.mExecutor = executor;
        this.mLocation = location;
    }

    @Override
    public void run() {
        Integer saveError = null;
        String errorMessage = null;
        Exception exception = null;
        try (ImageProxy imageToClose = this.mImage;
             FileOutputStream output = new FileOutputStream(this.mFile);){
            byte[] bytes = ImageUtil.imageToJpegByteArray(this.mImage);
            output.write(bytes);
            Exif exif = Exif.createFromFile(this.mFile);
            exif.attachTimestamp();
            exif.rotate(this.mOrientation);
            if (this.mIsReversedHorizontal) {
                exif.flipHorizontally();
            }
            if (this.mIsReversedVertical) {
                exif.flipVertically();
            }
            if (this.mLocation != null) {
                exif.attachLocation(this.mLocation);
            }
            exif.save();
        }
        catch (IOException e) {
            saveError = 0;
            errorMessage = "Failed to write or close the file";
            exception = e;
        }
        catch (ImageUtil.CodecFailedException e) {
            switch (e.getFailureType()) {
                case ENCODE_FAILED: {
                    saveError = 1;
                    errorMessage = "Failed to encode mImage";
                    break;
                }
                case DECODE_FAILED: {
                    saveError = 2;
                    errorMessage = "Failed to crop mImage";
                    break;
                }
                default: {
                    saveError = 3;
                    errorMessage = "Failed to transcode mImage";
                }
            }
            exception = e;
        }
        if (saveError != null) {
            this.postError(saveError, errorMessage, exception);
        } else {
            this.postSuccess();
        }
    }

    private void postSuccess() {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ImageSaver.this.mCallback.onImageSaved(ImageSaver.this.mFile);
            }
        });
    }

    private void postError(final int saveError, final String message, final @Nullable Throwable cause) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ImageSaver.this.mCallback.onError(saveError, message, cause);
            }
        });
    }

    public static interface OnImageSavedCallback {
        public void onImageSaved(File var1);

        public void onError(int var1, String var2, @Nullable Throwable var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SaveError {
        public static final int FILE_IO_FAILED = 0;
        public static final int ENCODE_FAILED = 1;
        public static final int CROP_FAILED = 2;
        public static final int UNKNOWN = 3;
    }
}

