/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.ImageReader;
import android.os.Handler;
import android.util.Log;
import android.util.LongSparseArray;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.CameraCaptureCallback;
import androidx.camera.core.CameraCaptureResult;
import androidx.camera.core.CameraCaptureResultImageInfo;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.ImageReaderProxy;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

class MetadataImageReader
implements ImageReaderProxy,
ForwardingImageProxy.OnImageCloseListener {
    private static final String TAG = "MetadataImageReader";
    private final Object mLock = new Object();
    private CameraCaptureCallback mCameraCaptureCallback = new CameraCaptureCallback(){

        @Override
        public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
            super.onCaptureCompleted(cameraCaptureResult);
            MetadataImageReader.this.resultIncoming(cameraCaptureResult);
        }
    };
    private ImageReaderProxy.OnImageAvailableListener mTransformedListener = new ImageReaderProxy.OnImageAvailableListener(){

        @Override
        public void onImageAvailable(ImageReaderProxy reader) {
            MetadataImageReader.this.imageIncoming(reader);
        }
    };
    @GuardedBy(value="mLock")
    private boolean mClosed = false;
    @GuardedBy(value="mLock")
    private final ImageReaderProxy mImageReaderProxy;
    @GuardedBy(value="mLock")
    @Nullable
    ImageReaderProxy.OnImageAvailableListener mListener;
    @GuardedBy(value="mLock")
    @Nullable
    private Executor mExecutor;
    @GuardedBy(value="mLock")
    private final LongSparseArray<ImageInfo> mPendingImageInfos = new LongSparseArray();
    @GuardedBy(value="mLock")
    private final LongSparseArray<ImageProxy> mPendingImages = new LongSparseArray();
    @GuardedBy(value="mLock")
    private int mImageProxiesIndex;
    @GuardedBy(value="mLock")
    private List<ImageProxy> mMatchedImageProxies;
    @GuardedBy(value="mLock")
    private final List<ImageProxy> mAcquiredImageProxies = new ArrayList<ImageProxy>();

    MetadataImageReader(int width, int height, int format, int maxImages, @Nullable Handler handler) {
        this.mImageReaderProxy = new AndroidImageReaderProxy(ImageReader.newInstance((int)width, (int)height, (int)format, (int)maxImages));
        this.init(CameraXExecutors.newHandlerExecutor(handler));
    }

    MetadataImageReader(ImageReaderProxy imageReaderProxy, @Nullable Handler handler) {
        this.mImageReaderProxy = imageReaderProxy;
        this.init(CameraXExecutors.newHandlerExecutor(handler));
    }

    private void init(Executor executor) {
        this.mExecutor = executor;
        this.mImageReaderProxy.setOnImageAvailableListener(this.mTransformedListener, executor);
        this.mImageProxiesIndex = 0;
        this.mMatchedImageProxies = new ArrayList<ImageProxy>(this.getMaxImages());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireLatestImage() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMatchedImageProxies.isEmpty()) {
                return null;
            }
            if (this.mImageProxiesIndex >= this.mMatchedImageProxies.size()) {
                throw new IllegalStateException("Maximum image number reached.");
            }
            ArrayList<ImageProxy> toClose = new ArrayList<ImageProxy>();
            for (int i = 0; i < this.mMatchedImageProxies.size() - 1; ++i) {
                if (this.mAcquiredImageProxies.contains(this.mMatchedImageProxies.get(i))) continue;
                toClose.add(this.mMatchedImageProxies.get(i));
            }
            for (ImageProxy image : toClose) {
                image.close();
            }
            this.mImageProxiesIndex = this.mMatchedImageProxies.size() - 1;
            ImageProxy acquiredImage = this.mMatchedImageProxies.get(this.mImageProxiesIndex++);
            this.mAcquiredImageProxies.add(acquiredImage);
            return acquiredImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireNextImage() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMatchedImageProxies.isEmpty()) {
                return null;
            }
            if (this.mImageProxiesIndex >= this.mMatchedImageProxies.size()) {
                throw new IllegalStateException("Maximum image number reached.");
            }
            ImageProxy acquiredImage = this.mMatchedImageProxies.get(this.mImageProxiesIndex++);
            this.mAcquiredImageProxies.add(acquiredImage);
            return acquiredImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            ArrayList<ImageProxy> imagesToClose = new ArrayList<ImageProxy>(this.mMatchedImageProxies);
            for (ImageProxy image : imagesToClose) {
                image.close();
            }
            this.mMatchedImageProxies.clear();
            this.mImageReaderProxy.close();
            this.mClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImageFormat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getImageFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxImages() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getMaxImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Surface getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mImageReaderProxy.getSurface();
        }
    }

    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @Nullable Handler handler) {
        this.setOnImageAvailableListener(listener, CameraXExecutors.newHandlerExecutor(handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener;
            this.mExecutor = executor;
            this.mImageReaderProxy.setOnImageAvailableListener(this.mTransformedListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onImageClose(ImageProxy image) {
        Object object = this.mLock;
        synchronized (object) {
            this.dequeImageProxy(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueImageProxy(SettableImageProxy image) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mMatchedImageProxies.size() < this.getMaxImages()) {
                image.addOnImageCloseListener(this);
                this.mMatchedImageProxies.add(image);
                if (this.mListener != null) {
                    if (this.mExecutor != null) {
                        this.mExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                MetadataImageReader.this.mListener.onImageAvailable(MetadataImageReader.this);
                            }
                        });
                    } else {
                        this.mListener.onImageAvailable(this);
                    }
                }
            } else {
                Log.d((String)"TAG", (String)"Maximum image number reached.");
                image.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeImageProxy(ImageProxy image) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mMatchedImageProxies.indexOf(image);
            if (index >= 0) {
                this.mMatchedImageProxies.remove(index);
                if (index <= this.mImageProxiesIndex) {
                    --this.mImageProxiesIndex;
                }
            }
            this.mAcquiredImageProxies.remove(image);
        }
    }

    CameraCaptureCallback getCameraCaptureCallback() {
        return this.mCameraCaptureCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageIncoming(ImageReaderProxy imageReader) {
        Object object = this.mLock;
        synchronized (object) {
            ImageProxy image;
            if (this.mClosed) {
                return;
            }
            int numAcquired = 0;
            do {
                image = null;
                try {
                    image = imageReader.acquireNextImage();
                }
                catch (IllegalStateException e) {
                    Log.d((String)TAG, (String)"Failed to acquire next image.", (Throwable)e);
                }
                finally {
                    if (image != null) {
                        ++numAcquired;
                        this.mPendingImages.put(image.getImageInfo().getTimestamp(), (Object)image);
                        this.matchImages();
                    }
                }
            } while (image != null && numAcquired < imageReader.getMaxImages());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resultIncoming(CameraCaptureResult cameraCaptureResult) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.mPendingImageInfos.put(cameraCaptureResult.getTimestamp(), (Object)new CameraCaptureResultImageInfo(cameraCaptureResult));
            this.matchImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStaleData() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPendingImages.size() == 0 || this.mPendingImageInfos.size() == 0) {
                return;
            }
            Long minImageProxyTimestamp = this.mPendingImages.keyAt(0);
            Long minImageInfoTimestamp = this.mPendingImageInfos.keyAt(0);
            Preconditions.checkArgument((!minImageInfoTimestamp.equals(minImageProxyTimestamp) ? 1 : 0) != 0);
            if (minImageInfoTimestamp > minImageProxyTimestamp) {
                for (int i = this.mPendingImages.size() - 1; i >= 0; --i) {
                    if (this.mPendingImages.keyAt(i) >= minImageInfoTimestamp) continue;
                    ImageProxy imageProxy = (ImageProxy)this.mPendingImages.valueAt(i);
                    imageProxy.close();
                    this.mPendingImages.removeAt(i);
                }
            } else {
                for (int i = this.mPendingImageInfos.size() - 1; i >= 0; --i) {
                    if (this.mPendingImageInfos.keyAt(i) >= minImageProxyTimestamp) continue;
                    this.mPendingImageInfos.removeAt(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void matchImages() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mPendingImageInfos.size() - 1; i >= 0; --i) {
                ImageInfo imageInfo = (ImageInfo)this.mPendingImageInfos.valueAt(i);
                long timestamp = imageInfo.getTimestamp();
                ImageProxy image = (ImageProxy)this.mPendingImages.get(timestamp);
                if (image == null) continue;
                this.mPendingImages.remove(timestamp);
                this.mPendingImageInfos.removeAt(i);
                this.enqueueImageProxy(new SettableImageProxy(image, imageInfo));
            }
            this.removeStaleData();
        }
    }
}

