/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.SingleCloseImageProxy;

final class ReferenceCountedImageProxy
extends ForwardingImageProxy {
    @GuardedBy(value="this")
    private int mReferenceCount = 1;

    ReferenceCountedImageProxy(ImageProxy image) {
        super(image);
    }

    @Nullable
    synchronized ImageProxy fork() {
        if (this.mReferenceCount <= 0) {
            return null;
        }
        ++this.mReferenceCount;
        return new SingleCloseImageProxy(this);
    }

    @Override
    public synchronized void close() {
        if (this.mReferenceCount > 0) {
            --this.mReferenceCount;
            if (this.mReferenceCount <= 0) {
                super.close();
            }
        }
    }

    synchronized int getReferenceCount() {
        return this.mReferenceCount;
    }
}

