/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.futures;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class ListFuture<V>
implements ListenableFuture<List<V>> {
    @Nullable
    List<? extends ListenableFuture<? extends V>> mFutures;
    @Nullable
    List<V> mValues;
    private final boolean mAllMustSucceed;
    @NonNull
    private final AtomicInteger mRemaining;
    @NonNull
    private final ListenableFuture<List<V>> mResult;
    CallbackToFutureAdapter.Completer<List<V>> mResultNotifier;

    ListFuture(@NonNull List<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed, @NonNull Executor listenerExecutor) {
        this.mFutures = (List)Preconditions.checkNotNull(futures);
        this.mValues = new ArrayList<V>(futures.size());
        this.mAllMustSucceed = allMustSucceed;
        this.mRemaining = new AtomicInteger(futures.size());
        this.mResult = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<List<V>>(){

            public Object attachCompleter(@NonNull CallbackToFutureAdapter.Completer<List<V>> completer) {
                Preconditions.checkState((ListFuture.this.mResultNotifier == null ? 1 : 0) != 0, (String)"The result can only set once!");
                ListFuture.this.mResultNotifier = completer;
                return "ListFuture[" + this + "]";
            }
        });
        this.init(listenerExecutor);
    }

    private void init(@NonNull Executor listenerExecutor) {
        this.addListener(new Runnable(){

            @Override
            public void run() {
                ListFuture.this.mValues = null;
                ListFuture.this.mFutures = null;
            }
        }, CameraXExecutors.directExecutor());
        if (this.mFutures.isEmpty()) {
            this.mResultNotifier.set(new ArrayList<V>(this.mValues));
            return;
        }
        for (int i = 0; i < this.mFutures.size(); ++i) {
            this.mValues.add(null);
        }
        List<ListenableFuture<V>> localFutures = this.mFutures;
        int i = 0;
        while (i < localFutures.size()) {
            final ListenableFuture<? extends V> listenable = localFutures.get(i);
            final int index = i++;
            listenable.addListener(new Runnable(){

                @Override
                public void run() {
                    ListFuture.this.setOneValue(index, listenable);
                }
            }, listenerExecutor);
        }
    }

    /*
     * Exception decompiling
     */
    void setOneValue(int index, @NonNull Future<? extends V> future) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addListener(@NonNull Runnable listener, @NonNull Executor executor) {
        this.mResult.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.mResult.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.mResult.isCancelled();
    }

    public boolean isDone() {
        return this.mResult.isDone();
    }

    @Nullable
    public List<V> get() throws InterruptedException, ExecutionException {
        this.callAllGets();
        return (List)this.mResult.get();
    }

    public List<V> get(long timeout, @NonNull TimeUnit unit) {
        throw new RuntimeException("Not supported.");
    }

    private void callAllGets() throws InterruptedException {
        List<ListenableFuture<V>> oldFutures = this.mFutures;
        if (oldFutures != null && !this.isDone()) {
            for (ListenableFuture<? extends V> listenableFuture : oldFutures) {
                while (!listenableFuture.isDone()) {
                    try {
                        listenableFuture.get();
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        if (!this.mAllMustSucceed) continue;
                        return;
                    }
                }
            }
        }
    }
}

