/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.ImageReader;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.SettableImageProxyBundle;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

class ProcessingImageReader
implements ImageReaderProxy {
    private static final String TAG = "ProcessingImageReader";
    final Object mLock = new Object();
    private ImageReaderProxy.OnImageAvailableListener mTransformedListener = new ImageReaderProxy.OnImageAvailableListener(){

        @Override
        public void onImageAvailable(@NonNull ImageReaderProxy reader) {
            ProcessingImageReader.this.imageIncoming(reader);
        }
    };
    private ImageReaderProxy.OnImageAvailableListener mImageProcessedListener = new ImageReaderProxy.OnImageAvailableListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageAvailable(@NonNull ImageReaderProxy reader) {
            Executor executor;
            ImageReaderProxy.OnImageAvailableListener listener;
            Object object = ProcessingImageReader.this.mLock;
            synchronized (object) {
                listener = ProcessingImageReader.this.mListener;
                executor = ProcessingImageReader.this.mExecutor;
                ProcessingImageReader.this.mSettableImageProxyBundle.reset();
                ProcessingImageReader.this.setupSettableImageProxyBundleCallbacks();
            }
            if (listener != null) {
                if (executor != null) {
                    executor.execute(() -> listener.onImageAvailable(ProcessingImageReader.this));
                } else {
                    listener.onImageAvailable(ProcessingImageReader.this);
                }
            }
        }
    };
    private FutureCallback<List<ImageProxy>> mCaptureStageReadyCallback = new FutureCallback<List<ImageProxy>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(@Nullable List<ImageProxy> imageProxyList) {
            SettableImageProxyBundle settableImageProxyBundle;
            Object object = ProcessingImageReader.this.mLock;
            synchronized (object) {
                settableImageProxyBundle = ProcessingImageReader.this.mSettableImageProxyBundle;
            }
            ProcessingImageReader.this.mCaptureProcessor.process(settableImageProxyBundle);
        }

        @Override
        public void onFailure(Throwable throwable) {
        }
    };
    @GuardedBy(value="mLock")
    private boolean mClosed = false;
    @GuardedBy(value="mLock")
    private final ImageReaderProxy mInputImageReader;
    @GuardedBy(value="mLock")
    private final ImageReaderProxy mOutputImageReader;
    @GuardedBy(value="mLock")
    @Nullable
    ImageReaderProxy.OnImageAvailableListener mListener;
    @GuardedBy(value="mLock")
    @Nullable
    Executor mExecutor;
    @NonNull
    final Executor mPostProcessExecutor;
    @NonNull
    final CaptureProcessor mCaptureProcessor;
    @GuardedBy(value="mLock")
    @NonNull
    SettableImageProxyBundle mSettableImageProxyBundle = new SettableImageProxyBundle(Collections.emptyList());
    private final List<Integer> mCaptureIdList = new ArrayList<Integer>();

    ProcessingImageReader(int width, int height, int format, int maxImages, @NonNull Executor postProcessExecutor, @NonNull CaptureBundle captureBundle, @NonNull CaptureProcessor captureProcessor) {
        this(new MetadataImageReader(width, height, format, maxImages), postProcessExecutor, captureBundle, captureProcessor);
    }

    ProcessingImageReader(@NonNull ImageReaderProxy imageReader, @NonNull Executor postProcessExecutor, @NonNull CaptureBundle captureBundle, @NonNull CaptureProcessor captureProcessor) {
        if (imageReader.getMaxImages() < captureBundle.getCaptureStages().size()) {
            throw new IllegalArgumentException("MetadataImageReader is smaller than CaptureBundle.");
        }
        this.mInputImageReader = imageReader;
        this.mOutputImageReader = new AndroidImageReaderProxy(ImageReader.newInstance((int)imageReader.getWidth(), (int)imageReader.getHeight(), (int)imageReader.getImageFormat(), (int)imageReader.getMaxImages()));
        this.mPostProcessExecutor = postProcessExecutor;
        this.mCaptureProcessor = captureProcessor;
        this.mCaptureProcessor.onOutputSurface(this.mOutputImageReader.getSurface(), this.getImageFormat());
        this.mCaptureProcessor.onResolutionUpdate(new Size(this.mInputImageReader.getWidth(), this.mInputImageReader.getHeight()));
        this.setCaptureBundle(captureBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireLatestImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mOutputImageReader.acquireLatestImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImageProxy acquireNextImage() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mOutputImageReader.acquireNextImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.mInputImageReader.close();
            this.mOutputImageReader.close();
            this.mSettableImageProxyBundle.close();
            this.mClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImageFormat() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getImageFormat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxImages() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getMaxImages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Surface getSurface() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInputImageReader.getSurface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOnImageAvailableListener(@NonNull ImageReaderProxy.OnImageAvailableListener listener, @NonNull Executor executor) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = (ImageReaderProxy.OnImageAvailableListener)Preconditions.checkNotNull((Object)listener);
            this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
            this.mInputImageReader.setOnImageAvailableListener(this.mTransformedListener, executor);
            this.mOutputImageReader.setOnImageAvailableListener(this.mImageProcessedListener, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOnImageAvailableListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = null;
            this.mExecutor = null;
            this.mInputImageReader.clearOnImageAvailableListener();
            this.mOutputImageReader.clearOnImageAvailableListener();
            this.mSettableImageProxyBundle.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCaptureBundle(@NonNull CaptureBundle captureBundle) {
        Object object = this.mLock;
        synchronized (object) {
            if (captureBundle.getCaptureStages() != null) {
                if (this.mInputImageReader.getMaxImages() < captureBundle.getCaptureStages().size()) {
                    throw new IllegalArgumentException("CaptureBundle is lager than InputImageReader.");
                }
                this.mCaptureIdList.clear();
                for (CaptureStage captureStage : captureBundle.getCaptureStages()) {
                    if (captureStage == null) continue;
                    this.mCaptureIdList.add(captureStage.getId());
                }
            }
            this.mSettableImageProxyBundle = new SettableImageProxyBundle(this.mCaptureIdList);
            this.setupSettableImageProxyBundleCallbacks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    CameraCaptureCallback getCameraCaptureCallback() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInputImageReader instanceof MetadataImageReader) {
                return ((MetadataImageReader)this.mInputImageReader).getCameraCaptureCallback();
            }
            return null;
        }
    }

    @GuardedBy(value="mLock")
    void setupSettableImageProxyBundleCallbacks() {
        ArrayList<ListenableFuture<ImageProxy>> futureList = new ArrayList<ListenableFuture<ImageProxy>>();
        for (Integer id : this.mCaptureIdList) {
            futureList.add(this.mSettableImageProxyBundle.getImageProxy(id));
        }
        Futures.addCallback(Futures.allAsList(futureList), this.mCaptureStageReadyCallback, this.mPostProcessExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void imageIncoming(ImageReaderProxy imageReader) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            ImageProxy image = null;
            try {
                image = imageReader.acquireNextImage();
            }
            catch (IllegalStateException e) {
                Log.e((String)TAG, (String)"Failed to acquire latest image.", (Throwable)e);
            }
            finally {
                if (image != null) {
                    Integer tag = (Integer)image.getImageInfo().getTag();
                    if (!this.mCaptureIdList.contains(tag)) {
                        Log.w((String)TAG, (String)("ImageProxyBundle does not contain this id: " + tag));
                        image.close();
                    } else {
                        this.mSettableImageProxyBundle.addImageProxy(image);
                    }
                }
            }
        }
    }
}

