/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class UseCaseGroup {
    private ViewPort mViewPort;
    private UseCase[] mUseCases;

    UseCaseGroup(@NonNull ViewPort viewPort, @NonNull UseCase[] useCases) {
        this.mViewPort = viewPort;
        this.mUseCases = useCases;
    }

    @NonNull
    public ViewPort getViewPort() {
        return this.mViewPort;
    }

    @NonNull
    public UseCase[] getUseCases() {
        return this.mUseCases;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Builder {
        private ViewPort mViewPort;
        private List<UseCase> mUseCases = new ArrayList<UseCase>();

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setViewPort(@NonNull ViewPort viewPort) {
            this.mViewPort = viewPort;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder addUseCase(@NonNull UseCase useCase) {
            this.mUseCases.add(useCase);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public UseCaseGroup build() {
            Preconditions.checkArgument((!this.mUseCases.isEmpty() ? 1 : 0) != 0, (Object)"UseCase must not be empty.");
            return new UseCaseGroup(this.mViewPort, this.mUseCases.toArray(new UseCase[0]));
        }
    }
}

