/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.impl.AutoValue_Config_Option;
import com.google.auto.value.AutoValue;
import java.util.Set;

public interface Config {
    public boolean containsOption(@NonNull Option<?> var1);

    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Option<ValueT> var1);

    @Nullable
    public <ValueT> ValueT retrieveOption(@NonNull Option<ValueT> var1, @Nullable ValueT var2);

    @Nullable
    public <ValueT> ValueT retrieveOptionWithPriority(@NonNull Option<ValueT> var1, @NonNull OptionPriority var2);

    @NonNull
    public OptionPriority getOptionPriority(@NonNull Option<?> var1);

    public void findOptions(@NonNull String var1, @NonNull OptionMatcher var2);

    @NonNull
    public Set<Option<?>> listOptions();

    @NonNull
    public Set<OptionPriority> getPriorities(@NonNull Option<?> var1);

    public static boolean hasConflict(@NonNull OptionPriority priority1, @NonNull OptionPriority priority2) {
        if (priority1 == OptionPriority.ALWAYS_OVERRIDE && priority2 == OptionPriority.ALWAYS_OVERRIDE) {
            return true;
        }
        return priority1 == OptionPriority.REQUIRED && priority2 == OptionPriority.REQUIRED;
    }

    public static enum OptionPriority {
        ALWAYS_OVERRIDE,
        REQUIRED,
        OPTIONAL;

    }

    @AutoValue
    public static abstract class Option<T> {
        Option() {
        }

        @NonNull
        public static <T> Option<T> create(@NonNull String id, @NonNull Class<?> valueClass) {
            return Option.create(id, valueClass, null);
        }

        @NonNull
        public static <T> Option<T> create(@NonNull String id, @NonNull Class<?> valueClass, @Nullable Object token) {
            return new AutoValue_Config_Option(id, valueClass, token);
        }

        @NonNull
        public abstract String getId();

        @NonNull
        public abstract Class<T> getValueClass();

        @Nullable
        public abstract Object getToken();
    }

    public static interface OptionMatcher {
        public boolean onOptionMatched(@NonNull Option<?> var1);
    }
}

