/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import java.util.HashMap;
import java.util.Map;

public final class ExtendableUseCaseConfigFactory
implements UseCaseConfigFactory {
    private final Map<Class<?>, ConfigProvider<?>> mDefaultProviders = new HashMap();

    public <C extends Config> void installDefaultProvider(@NonNull Class<C> configType, @NonNull ConfigProvider<C> defaultProvider) {
        this.mDefaultProviders.put(configType, defaultProvider);
    }

    @Override
    @Nullable
    public <C extends UseCaseConfig<?>> C getConfig(@NonNull Class<C> configType, @Nullable CameraInfo cameraInfo) {
        ConfigProvider<?> provider = this.mDefaultProviders.get(configType);
        if (provider != null) {
            return (C)((UseCaseConfig)provider.getConfig(cameraInfo));
        }
        return null;
    }
}

